/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import { betaLibrariesAccessesDelete } from "../funcs/betaLibrariesAccessesDelete.js";
import { betaLibrariesAccessesList } from "../funcs/betaLibrariesAccessesList.js";
import { betaLibrariesAccessesUpdateOrCreate } from "../funcs/betaLibrariesAccessesUpdateOrCreate.js";
import { ClientSDK, RequestOptions } from "../lib/sdks.js";
import * as components from "../models/components/index.js";
import * as operations from "../models/operations/index.js";
import { unwrapAsync } from "../types/fp.js";

export class Accesses extends ClientSDK {
  /**
   * List all of the access to this library.
   *
   * @remarks
   * Given a library, list all of the Entity that have access and to what level.
   */
  async list(
    request: operations.LibrariesShareListV1Request,
    options?: RequestOptions,
  ): Promise<components.ListSharingOut> {
    return unwrapAsync(betaLibrariesAccessesList(
      this,
      request,
      options,
    ));
  }

  /**
   * Create or update an access level.
   *
   * @remarks
   * Given a library id, you can create or update the access level of an entity. You have to be owner of the library to share a library. An owner cannot change their own role. A library cannot be shared outside of the organization.
   */
  async updateOrCreate(
    request: operations.LibrariesShareCreateV1Request,
    options?: RequestOptions,
  ): Promise<components.SharingOut> {
    return unwrapAsync(betaLibrariesAccessesUpdateOrCreate(
      this,
      request,
      options,
    ));
  }

  /**
   * Delete an access level.
   *
   * @remarks
   * Given a library id, you can delete the access level of an entity. An owner cannot delete it's own access. You have to be the owner of the library to delete an acces other than yours.
   */
  async delete(
    request: operations.LibrariesShareDeleteV1Request,
    options?: RequestOptions,
  ): Promise<components.SharingOut> {
    return unwrapAsync(betaLibrariesAccessesDelete(
      this,
      request,
      options,
    ));
  }
}
