/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export type DeleteFileOut = {
  /**
   * The ID of the deleted file.
   */
  id: string;
  /**
   * The object type that was deleted
   */
  object: string;
  /**
   * The deletion status.
   */
  deleted: boolean;
};

/** @internal */
export const DeleteFileOut$inboundSchema: z.ZodType<
  DeleteFileOut,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  object: z.string(),
  deleted: z.boolean(),
});

/** @internal */
export type DeleteFileOut$Outbound = {
  id: string;
  object: string;
  deleted: boolean;
};

/** @internal */
export const DeleteFileOut$outboundSchema: z.ZodType<
  DeleteFileOut$Outbound,
  z.ZodTypeDef,
  DeleteFileOut
> = z.object({
  id: z.string(),
  object: z.string(),
  deleted: z.boolean(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace DeleteFileOut$ {
  /** @deprecated use `DeleteFileOut$inboundSchema` instead. */
  export const inboundSchema = DeleteFileOut$inboundSchema;
  /** @deprecated use `DeleteFileOut$outboundSchema` instead. */
  export const outboundSchema = DeleteFileOut$outboundSchema;
  /** @deprecated use `DeleteFileOut$Outbound` instead. */
  export type Outbound = DeleteFileOut$Outbound;
}

export function deleteFileOutToJSON(deleteFileOut: DeleteFileOut): string {
  return JSON.stringify(DeleteFileOut$outboundSchema.parse(deleteFileOut));
}

export function deleteFileOutFromJSON(
  jsonString: string,
): SafeParseResult<DeleteFileOut, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => DeleteFileOut$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'DeleteFileOut' from JSON`,
  );
}
