"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Chat = void 0;
const chatComplete_js_1 = require("../funcs/chatComplete.js");
const chatStream_js_1 = require("../funcs/chatStream.js");
const sdks_js_1 = require("../lib/sdks.js");
const fp_js_1 = require("../types/fp.js");
const structChat_js_1 = require("../extra/structChat.js");
// #endregion imports
class Chat extends sdks_js_1.ClientSDK {
    // #region sdk-class-body
    /**
     * Chat Completion with the response parsed in the same format as the input requestFormat.
     *
     * @remarks
     * The response will be parsed back to the initial Zod object passed in the requestFormat field.
     */
    async parse(request, options) {
        const ccr_request = (0, structChat_js_1.transformToChatCompletionRequest)(request);
        const response = await (0, fp_js_1.unwrapAsync)((0, chatComplete_js_1.chatComplete)(this, ccr_request, options));
        const parsed_response = (0, structChat_js_1.convertToParsedChatCompletionResponse)(response, request.responseFormat);
        return parsed_response;
    }
    /**
     * Stream chat completion with a parsed request input.
     *
     * @remarks
     * Unlike the .parse method, this method will return a stream of events containing the JSON response. It will not be parsed back to the initial Zod object.
     * If you need to parse the stream, see the examples/src/async_structured_outputs.ts file.
     */
    async parseStream(request, options) {
        const ccr_request = (0, structChat_js_1.transformToChatCompletionRequest)(request);
        return (0, fp_js_1.unwrapAsync)((0, chatStream_js_1.chatStream)(this, ccr_request, options));
    }
    // #endregion sdk-class-body
    /**
     * Chat Completion
     */
    async complete(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, chatComplete_js_1.chatComplete)(this, request, options));
    }
    /**
     * Stream chat completion
     *
     * @remarks
     * Mistral AI provides the ability to stream responses back to a client in order to allow partial results for certain requests. Tokens will be sent as data-only server-sent events as they become available, with the stream terminated by a data: [DONE] message. Otherwise, the server will hold the request open until the timeout or until completion, with the response containing the full result as JSON.
     */
    async stream(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, chatStream_js_1.chatStream)(this, request, options));
    }
}
exports.Chat = Chat;
//# sourceMappingURL=chat.js.map