import * as z from "zod";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
export type AgentsApiV1ConversationsMessagesRequest = {
    /**
     * ID of the conversation from which we are fetching messages.
     */
    conversationId: string;
};
/** @internal */
export declare const AgentsApiV1ConversationsMessagesRequest$inboundSchema: z.ZodType<AgentsApiV1ConversationsMessagesRequest, z.ZodTypeDef, unknown>;
/** @internal */
export type AgentsApiV1ConversationsMessagesRequest$Outbound = {
    conversation_id: string;
};
/** @internal */
export declare const AgentsApiV1ConversationsMessagesRequest$outboundSchema: z.ZodType<AgentsApiV1ConversationsMessagesRequest$Outbound, z.ZodTypeDef, AgentsApiV1ConversationsMessagesRequest>;
/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export declare namespace AgentsApiV1ConversationsMessagesRequest$ {
    /** @deprecated use `AgentsApiV1ConversationsMessagesRequest$inboundSchema` instead. */
    const inboundSchema: z.ZodType<AgentsApiV1ConversationsMessagesRequest, z.ZodTypeDef, unknown>;
    /** @deprecated use `AgentsApiV1ConversationsMessagesRequest$outboundSchema` instead. */
    const outboundSchema: z.ZodType<AgentsApiV1ConversationsMessagesRequest$Outbound, z.ZodTypeDef, AgentsApiV1ConversationsMessagesRequest>;
    /** @deprecated use `AgentsApiV1ConversationsMessagesRequest$Outbound` instead. */
    type Outbound = AgentsApiV1ConversationsMessagesRequest$Outbound;
}
export declare function agentsApiV1ConversationsMessagesRequestToJSON(agentsApiV1ConversationsMessagesRequest: AgentsApiV1ConversationsMessagesRequest): string;
export declare function agentsApiV1ConversationsMessagesRequestFromJSON(jsonString: string): SafeParseResult<AgentsApiV1ConversationsMessagesRequest, SDKValidationError>;
//# sourceMappingURL=agentsapiv1conversationsmessages.d.ts.map