/**
 * Workspace Manager — Per-task workspace directories under ~/.ami/workspace/.
 *
 * Ported from WorkingDirectoryManager in Python daemon.
 */
/**
 * Create an isolated workspace directory for a task.
 * Returns the absolute path.
 */
export declare function createTaskWorkspace(taskId: string): string;
/**
 * Get the workspace path for a task (may not exist yet).
 */
export declare function getTaskWorkspacePath(taskId: string): string;
/**
 * Get the base workspace directory.
 */
export declare function getWorkspaceBase(): string;
/**
 * Clean up a task workspace.
 */
export declare function cleanupTaskWorkspace(taskId: string): boolean;
//# sourceMappingURL=workspace-manager.d.ts.map