/**
 * Lightweight i18n for backend SSE messages.
 *
 * Ported from i18n.py.
 *
 * Provides language detection and translation for user-visible messages
 * sent via SSE events (AgentReport, DecomposeProgress).
 */
/**
 * Detect language from user input text.
 * Returns "zh" if text contains CJK characters, else "en".
 */
export declare function detectLanguage(text: string): "en" | "zh";
/**
 * Translate a message key to the given language.
 *
 * @param key - Dot-separated translation key (e.g. "executor.running")
 * @param lang - Language code ("en" or "zh"). Defaults to "en"
 * @param vars - Interpolation variables for template replacement
 * @returns Translated and interpolated string. Falls back to English, then to key.
 */
export declare function t(key: string, lang?: string, vars?: Record<string, string | number>): string;
//# sourceMappingURL=i18n.d.ts.map