/**
 * Replan Tools — agent can dynamically add follow-up subtasks.
 *
 * Ported from replan_toolkit.py.
 *
 * Two tools:
 * - replan_review_context: View all subtasks and workspace files
 * - replan_split_and_handoff: Save progress and add follow-up subtasks
 */
import type { AgentTool } from "@mariozechner/pi-agent-core";
import { type AMISubtask } from "../agent/schemas.js";
/** Minimal interface for the executor (avoid circular import) */
interface ExecutorRef {
    readonly subtasks: AMISubtask[];
    addSubtasksAsync(newSubtasks: AMISubtask[], afterSubtaskId?: string): Promise<string[]>;
}
export declare function createReplanTools(executor: ExecutorRef, currentSubtaskId: string, workspaceDir?: string): {
    tools: AgentTool<any>[];
    getHandoffResult: () => string | undefined;
};
export {};
//# sourceMappingURL=replan-tools.d.ts.map