/**
 * Memory Tools — Query AMI's Workflow Memory (V2).
 *
 * Ported from memory_toolkit.py.
 *
 * LLM-exposed tool: query_page_operations
 * Framework methods: queryTask, queryNavigation, queryActions, planTask
 * HTTP calls to cloud backend: /api/v1/memory/*
 */
import type { AgentTool } from "@mariozechner/pi-agent-core";
import type { SSEEmitter } from "../events/emitter.js";
export interface Intent {
    id: string;
    description: string;
    action_type: string;
    selector?: string;
    value?: string;
}
export interface IntentSequence {
    id: string;
    intents: Intent[];
    description: string;
}
export interface MemoryState {
    id: string;
    url: string;
    title: string;
    description: string;
}
export interface MemoryAction {
    id: string;
    source_id: string;
    target_id: string;
    action_type: string;
    description?: string;
    trigger?: Record<string, unknown>;
    trigger_sequence_id?: string;
}
export interface ExecutionStep {
    index: number;
    state_id: string;
    in_page_sequence_ids: string[];
    navigation_action_id?: string;
    navigation_sequence_id?: string;
}
export interface CognitivePhrase {
    id: string;
    description: string;
    states: MemoryState[];
    actions: MemoryAction[];
    execution_plan: ExecutionStep[];
}
export interface QueryResult {
    success: boolean;
    level?: string;
    cognitive_phrases?: CognitivePhrase[];
    states?: MemoryState[];
    actions?: MemoryAction[];
    intent_sequences?: IntentSequence[];
    error?: string;
}
export interface PlanStepData {
    index: number;
    content: string;
    source: string;
    phrase_id?: string;
    state_ids: string[];
    workflow_guide: string;
}
export interface MemoryPlanData {
    task: string;
    coverage: string;
    preferences: string[];
    uncovered_steps: string[];
    steps: PlanStepData[];
}
export interface MemoryPlanResult {
    memory_plan: MemoryPlanData;
    debug_trace?: Record<string, unknown>;
}
export declare function formatCognitivePhrase(phrase: CognitivePhrase): string;
export declare function formatTaskResult(result: QueryResult): string;
export declare function formatPageOperations(result: QueryResult): string;
export declare function isTaskMemoryHit(result: QueryResult): boolean;
export declare function getTaskMemoryLevel(result: QueryResult): "L1" | "L2" | "L3";
export declare class MemoryToolkit {
    private baseUrl;
    private taskId;
    private emitter?;
    constructor(opts: {
        memoryApiBaseUrl: string;
        taskId: string;
        emitter?: SSEEmitter;
    });
    queryTask(task: string): Promise<QueryResult>;
    queryNavigation(startState: string, endState: string): Promise<QueryResult>;
    queryActions(currentState: string, target?: string): Promise<QueryResult>;
    planTask(task: string): Promise<MemoryPlanResult>;
    getTools(): AgentTool<any>[];
}
export declare function createMemoryTools(opts: {
    memoryApiBaseUrl: string;
    taskId: string;
    emitter?: SSEEmitter;
}): {
    toolkit: MemoryToolkit;
    tools: AgentTool<any>[];
};
//# sourceMappingURL=memory-tools.d.ts.map