/**
 * Quick Task Service — Main execution orchestration.
 *
 * Ported from quick_task_service.py.
 *
 * Connects the orchestrator agent pipeline to the HTTP routes.
 * Handles: task submission, multi-turn conversation, cancellation,
 * file attachments, result aggregation.
 */
import { OrchestratorSession } from "../agent/orchestrator.js";
import type { TaskState } from "./task-state.js";
/**
 * Main entry point: start task execution using the orchestrator pipeline.
 * Called from quick-task route's POST /execute handler.
 */
export declare function executeTaskPipeline(state: TaskState): Promise<void>;
export declare function cancelTask(taskId: string): boolean;
export declare function injectMessage(taskId: string, message: string): boolean;
export declare function pauseTask(taskId: string): boolean;
export declare function resumeTask(taskId: string): boolean;
export declare function getActiveSession(taskId: string): OrchestratorSession | undefined;
//# sourceMappingURL=quick-task-service.d.ts.map