/**
 * Context Builder — Conversation context formatting for LLM prompts.
 *
 * Ported from context_builder.py.
 *
 * Builds and formats conversation context for LLM prompt injection.
 * Collects files from working directories, checks history limits,
 * and summarizes long histories.
 */
import type { TaskState } from "./task-state.js";
/**
 * Build conversation context from task state history.
 */
export declare function buildConversationContext(state: TaskState, opts?: {
    header?: string;
    skipFiles?: boolean;
    maxEntries?: number;
    includeToolCalls?: boolean;
}): string;
/**
 * Check if conversation history exceeds maximum length.
 */
export declare function checkHistoryLength(state: TaskState, maxLength?: number): {
    exceeded: boolean;
    totalLength: number;
};
/**
 * Build enhanced prompt with conversation context + current task.
 */
export declare function buildEnhancedPrompt(state: TaskState, currentTask: string, opts?: {
    includeContext?: boolean;
    maxContextEntries?: number;
}): string;
export declare function recordTaskCompletion(state: TaskState, summary: string, filesCreated?: string[], status?: string): void;
export declare function recordUserMessage(state: TaskState, message: string): void;
export declare function recordAssistantResponse(state: TaskState, response: string): void;
export declare function recordToolCall(state: TaskState, toolName: string, toolInput?: Record<string, unknown>, toolResult?: string): void;
//# sourceMappingURL=context-builder.d.ts.map