/**
 * Cloud Client — HTTP client for AMI cloud backend API.
 *
 * Ported from CloudClient in Python daemon.
 *
 * Endpoints: check_version, memory/plan, memory/query, memory/learn,
 * memory/add, memory/stats, memory/phrases, recordings, intent-builder, etc.
 */
/** Per-request credentials to avoid singleton mutation races */
export interface RequestCredentials {
    token?: string;
}
export declare class CloudClient {
    private baseUrl;
    private timeout;
    constructor(opts?: {
        baseUrl?: string;
    });
    private request;
    private get;
    private post;
    private del;
    private patch;
    checkVersion(clientVersion: string, platform: string, creds?: RequestCredentials): Promise<{
        compatible: boolean;
        minimum_version?: string;
        update_url?: string;
        message?: string;
    }>;
    memoryQuery(body: Record<string, unknown>, creds?: RequestCredentials): Promise<unknown>;
    memoryPlan(body: Record<string, unknown>, creds?: RequestCredentials): Promise<unknown>;
    memoryLearn(body: Record<string, unknown>, creds?: RequestCredentials): Promise<unknown>;
    memoryAdd(body: Record<string, unknown>, creds?: RequestCredentials): Promise<unknown>;
    memoryStats(creds?: RequestCredentials): Promise<unknown>;
    memoryDelete(creds?: RequestCredentials): Promise<unknown>;
    listPhrases(limit?: number, creds?: RequestCredentials): Promise<unknown>;
    listPublicPhrases(limit?: number, sort?: string, creds?: RequestCredentials): Promise<unknown>;
    getPhrase(phraseId: string, source?: string, creds?: RequestCredentials): Promise<unknown>;
    deletePhrase(phraseId: string, creds?: RequestCredentials): Promise<unknown>;
    publishPhrase(phraseId: string, creds?: RequestCredentials): Promise<unknown>;
    unpublishPhrase(phraseId: string, creds?: RequestCredentials): Promise<unknown>;
    getPublishStatus(phraseId: string, creds?: RequestCredentials): Promise<unknown>;
    getRecording(sessionId: string, creds?: RequestCredentials): Promise<unknown>;
    analyzeRecording(sessionId: string, userId: string, creds?: RequestCredentials): Promise<unknown>;
    createIntentBuilderSession(body: Record<string, unknown>, creds?: RequestCredentials): Promise<unknown>;
    intentBuilderChat(sessionId: string, message: string, creds?: RequestCredentials): Promise<unknown>;
    getIntentBuilderState(sessionId: string, creds?: RequestCredentials): Promise<unknown>;
    deleteIntentBuilderSession(sessionId: string, creds?: RequestCredentials): Promise<unknown>;
    /**
     * Stream SSE from intent builder session.
     * Returns raw fetch Response for SSE streaming.
     */
    intentBuilderStream(sessionId: string, creds?: RequestCredentials): Promise<Response>;
}
export declare function getCloudClient(): CloudClient;
export declare function setCloudClient(client: CloudClient): void;
//# sourceMappingURL=cloud-client.d.ts.map