/**
 * Unified Agent System Prompts — all child agent system prompts.
 *
 * Ported from agent_factories.py system prompt constants.
 * Template variables: {platform_system}, {platform_machine}, {working_directory}, {now_str}
 */
export interface PromptVars {
    platformSystem: string;
    platformMachine: string;
    workingDirectory: string;
    nowStr: string;
}
export declare function getDefaultPromptVars(workingDirectory?: string): PromptVars;
export type AgentType = "browser" | "document" | "code" | "multi_modal";
export declare function getAgentSystemPrompt(agentType: AgentType, vars?: Partial<PromptVars>): string;
//# sourceMappingURL=unified-agent.d.ts.map