/**
 * SSE Event Types — matches Python Pydantic models exactly for frontend compatibility.
 *
 * Wire format: `data: {"step": "<action>", "data": {...}}\n\n`
 * NO `event:` prefix lines.
 */
// ===== Action Constants =====
export const Action = {
    // User -> Backend (Input Actions)
    improve: "improve",
    update_task: "update_task",
    start: "start",
    stop: "stop",
    pause: "pause",
    resume: "resume",
    supplement: "supplement",
    human_response: "human_response",
    // Task lifecycle
    task_state: "task_state",
    new_task_state: "new_task_state",
    task_started: "task_started",
    task_completed: "task_completed",
    task_failed: "task_failed",
    task_cancelled: "task_cancelled",
    // Planning
    plan_started: "plan_started",
    plan_progress: "plan_progress",
    plan_generated: "plan_generated",
    // Task decomposition
    task_decomposed: "task_decomposed",
    subtask_state: "subtask_state",
    task_replanned: "task_replanned",
    streaming_decompose: "streaming_decompose",
    decompose_progress: "decompose_progress",
    // Workforce events
    workforce_started: "workforce_started",
    workforce_completed: "workforce_completed",
    workforce_stopped: "workforce_stopped",
    worker_assigned: "worker_assigned",
    worker_started: "worker_started",
    worker_completed: "worker_completed",
    worker_failed: "worker_failed",
    dynamic_tasks_added: "dynamic_tasks_added",
    assign_task: "assign_task",
    // Agent lifecycle
    activate_agent: "activate_agent",
    deactivate_agent: "deactivate_agent",
    agent_thinking: "agent_thinking",
    agent_started: "agent_started",
    // Step/iteration execution
    step_started: "step_started",
    step_progress: "step_progress",
    step_completed: "step_completed",
    step_failed: "step_failed",
    loop_iteration: "loop_iteration",
    // Toolkit events
    activate_toolkit: "activate_toolkit",
    deactivate_toolkit: "deactivate_toolkit",
    tool_started: "tool_started",
    tool_completed: "tool_completed",
    tool_failed: "tool_failed",
    tool_executed: "tool_executed",
    // Specific tool events
    terminal: "terminal",
    browser_action: "browser_action",
    write_file: "write_file",
    screenshot: "screenshot",
    // User interaction
    ask: "ask",
    notice: "notice",
    human_question: "human_question",
    human_message: "human_message",
    wait_confirm: "wait_confirm",
    confirmed: "confirmed",
    // Agent report
    agent_report: "agent_report",
    // Memory events
    memory_query: "memory_query",
    memory_result: "memory_result",
    memory_loaded: "memory_loaded",
    memory_level: "memory_level",
    memory_event: "memory_event",
    // Reasoner events
    reasoner_query_started: "reasoner_query_started",
    reasoner_workflow_started: "reasoner_workflow_started",
    reasoner_navigate: "reasoner_navigate",
    reasoner_intent_executed: "reasoner_intent_executed",
    reasoner_intent_failed: "reasoner_intent_failed",
    reasoner_workflow_completed: "reasoner_workflow_completed",
    reasoner_fallback: "reasoner_fallback",
    // LLM events
    llm_request: "llm_request",
    llm_response: "llm_response",
    llm_reasoning: "llm_reasoning",
    llm_error: "llm_error",
    context_too_long: "context_too_long",
    context_warning: "context_warning",
    // System events
    heartbeat: "heartbeat",
    error: "error",
    end: "end",
    connected: "connected",
};
// ===== Terminal action types (stream closes after these) =====
export const TERMINAL_ACTIONS = new Set([
    Action.end,
]);
//# sourceMappingURL=types.js.map