/**
 * SSE Emitter — queue-based event emission for streaming to clients.
 *
 * Wire format: `data: {"step": "<action>", "data": {...}}\n\n`
 */
import { type ActionData, type FileAttachment } from "./types.js";
export declare function sseJson(step: string, data: unknown): string;
export declare function sseAction(actionData: ActionData): string;
export declare function sseComment(comment: string): string;
export declare function sseHeartbeat(): string;
export declare class SSEEmitter {
    private _queue;
    private _waiters;
    private _closed;
    private _taskId?;
    private _agentName?;
    private _startTime?;
    configure(taskId?: string, agentName?: string): this;
    get taskId(): string | undefined;
    get isClosed(): boolean;
    emit(actionData: ActionData): void;
    /** Get next event, with optional timeout in ms. Returns null on timeout or close. */
    getEvent(timeoutMs?: number): Promise<ActionData | null>;
    close(): void;
    emitAgentActivate(agentName?: string, agentId?: string, message?: string): void;
    emitAgentDeactivate(agentName?: string, agentId?: string, message?: string, tokensUsed?: number): void;
    emitToolkitActivate(toolkitName: string, methodName: string, inputPreview?: string, message?: string, agentName?: string): void;
    emitToolkitDeactivate(toolkitName: string, methodName: string, outputPreview?: string, success?: boolean, durationMs?: number, message?: string, agentName?: string): void;
    emitAgentThinking(content: string, agentName?: string, step?: number): void;
    emitTerminal(command: string, output?: string, exitCode?: number, workingDirectory?: string, durationMs?: number): void;
    emitBrowserAction(actionType: string, target?: string, value?: string, success?: boolean, pageUrl?: string, pageTitle?: string, screenshotUrl?: string, webviewId?: string): void;
    emitScreenshot(screenshot: string, url?: string, pageTitle?: string, tabId?: string, webviewId?: string): void;
    emitWriteFile(filePath: string, fileName: string, fileSize?: number, contentPreview?: string, mimeType?: string): void;
    emitNotice(title: string, message: string, level?: string, durationMs?: number): void;
    emitError(error: string, errorType?: string, recoverable?: boolean, details?: Record<string, unknown>): void;
    emitHeartbeat(): void;
    emitAgentReport(message: string, reportType?: string, agentType?: string, executorId?: string, taskLabel?: string, subtaskLabel?: string): void;
    emitEnd(status: string, message?: string, result?: unknown): void;
    emitWaitConfirm(content: string, question: string, context?: string, attachments?: FileAttachment[], executorId?: string, taskLabel?: string): void;
    emitTaskDecomposed(subtasks: Record<string, unknown>[], summaryTask?: string, originalTaskId?: string): void;
    emitSubtaskState(subtaskId: string, state: string, result?: string, failureCount?: number, executorId?: string, taskLabel?: string): void;
    emitTaskReplanned(subtasks: Record<string, unknown>[], originalTaskId?: string, reason?: string): void;
    emitWorkerAssigned(workerName: string, subtaskId: string, subtaskContent: string, workerId?: string, executorId?: string, taskLabel?: string): void;
    emitWorkerCompleted(workerName: string, subtaskId: string, resultPreview?: string, durationSeconds?: number, workerId?: string, executorId?: string, taskLabel?: string): void;
    emitWorkerFailed(workerName: string, subtaskId: string, error: string, failureCount?: number, willRetry?: boolean, workerId?: string, executorId?: string, taskLabel?: string): void;
    emitMemoryResult(pathsCount: number, paths: Record<string, unknown>[], hasWorkflow?: boolean, method?: string): void;
    emitStepStarted(stepIndex: number, stepName: string, stepDescription?: string): void;
    emitStepCompleted(stepIndex: number, stepName: string, result?: string, durationSeconds?: number): void;
    emitStepFailed(stepIndex: number, stepName: string, error: string, recoverable?: boolean): void;
}
//# sourceMappingURL=emitter.d.ts.map