/**
 * Browser configuration — timeouts, retry counts, page stability thresholds.
 * Ported from config_loader.py.
 */
export declare const BrowserConfig: {
    readonly actionTimeout: 3000;
    readonly shortTimeout: 5000;
    readonly navigationTimeout: 10000;
    readonly networkIdleTimeout: 5000;
    readonly screenshotTimeout: 15000;
    readonly stabilityTimeout: 1500;
    readonly domLoadedTimeout: 5000;
    readonly maxScrollAmount: 5000;
    readonly logLimit: 1000;
    readonly viewportWidth: 1920;
    readonly viewportHeight: 1080;
    readonly poolSize: 16;
    readonly poolMarkerUrl: "about:blank?ami=pool";
    readonly claimedMarkerUrl: "about:blank?ami=claimed";
    readonly maxRetries: 3;
    readonly retryDelay: 500;
};
/**
 * User agent strings for stealth mode (platform-specific).
 */
export declare function getUserAgent(): string;
/**
 * HTTP headers for stealth mode.
 */
export declare function getStealthHeaders(): Record<string, string>;
//# sourceMappingURL=config.d.ts.map