/**
 * ActionExecutor — Executes high-level actions on a Playwright Page.
 *
 * Ported from action_executor.py.
 *
 * Key concepts:
 * - 13 action types: click, type, select, wait, extract, scroll, enter,
 *   mouse_control, mouse_drag, press_key, navigate, back, forward
 * - Click: aria-ref selector, Ctrl+Click for new tab, force click fallback
 * - Mouse control: JS elementFromPoint + dispatchEvent (off-screen WebContentsView)
 * - Type: page.fill()
 * - Scroll: window.scrollBy() with clamping
 */
import type { Page } from "playwright";
type ActionDict = Record<string, unknown>;
type ActionResult = {
    success: boolean;
    message: string;
    details: Record<string, unknown>;
};
export declare class ActionExecutor {
    private page;
    private session;
    private defaultTimeout;
    private shortTimeout;
    private maxScrollAmount;
    constructor(page: Page, session?: any);
    execute(action: ActionDict): Promise<ActionResult>;
    static shouldUpdateSnapshot(action: ActionDict): boolean;
    private _click;
    private _type;
    private _select;
    private _wait;
    private _extract;
    private _scroll;
    private _enter;
    private _mouseControl;
    private _mouseDrag;
    private _pressKey;
    private _navigate;
    private _back;
    private _forward;
    private _validCoordinates;
}
export {};
//# sourceMappingURL=action-executor.d.ts.map