/**
 * Agent Pipeline Schemas — subtask model, state enum, decomposition types.
 *
 * Ported from ami_task_executor.py (SubtaskState, AMISubtask).
 */
// ===== Subtask State Enum =====
export var SubtaskState;
(function (SubtaskState) {
    SubtaskState["PENDING"] = "PENDING";
    SubtaskState["RUNNING"] = "RUNNING";
    SubtaskState["DONE"] = "DONE";
    SubtaskState["FAILED"] = "FAILED";
})(SubtaskState || (SubtaskState = {}));
/** Create a new AMISubtask with defaults */
export function createSubtask(opts) {
    return {
        id: opts.id,
        content: opts.content,
        agentType: opts.agentType,
        dependsOn: opts.dependsOn ?? [],
        workflowGuide: opts.workflowGuide,
        memoryLevel: opts.memoryLevel ?? "L3",
        state: SubtaskState.PENDING,
        retryCount: 0,
    };
}
//# sourceMappingURL=schemas.js.map