/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import { betaConversationsAppend } from "../funcs/betaConversationsAppend.js";
import { betaConversationsAppendStream } from "../funcs/betaConversationsAppendStream.js";
import { betaConversationsGet } from "../funcs/betaConversationsGet.js";
import { betaConversationsGetHistory } from "../funcs/betaConversationsGetHistory.js";
import { betaConversationsGetMessages } from "../funcs/betaConversationsGetMessages.js";
import { betaConversationsList } from "../funcs/betaConversationsList.js";
import { betaConversationsRestart } from "../funcs/betaConversationsRestart.js";
import { betaConversationsRestartStream } from "../funcs/betaConversationsRestartStream.js";
import { betaConversationsStart } from "../funcs/betaConversationsStart.js";
import { betaConversationsStartStream } from "../funcs/betaConversationsStartStream.js";
import { EventStream } from "../lib/event-streams.js";
import { ClientSDK, RequestOptions } from "../lib/sdks.js";
import * as components from "../models/components/index.js";
import * as operations from "../models/operations/index.js";
import { unwrapAsync } from "../types/fp.js";

export class Conversations extends ClientSDK {
  /**
   * Create a conversation and append entries to it.
   *
   * @remarks
   * Create a new conversation, using a base model or an agent and append entries. Completion and tool executions are run and the response is appended to the conversation.Use the returned conversation_id to continue the conversation.
   */
  async start(
    request: components.ConversationRequest,
    options?: RequestOptions,
  ): Promise<components.ConversationResponse> {
    return unwrapAsync(betaConversationsStart(
      this,
      request,
      options,
    ));
  }

  /**
   * List all created conversations.
   *
   * @remarks
   * Retrieve a list of conversation entities sorted by creation time.
   */
  async list(
    request?: operations.AgentsApiV1ConversationsListRequest | undefined,
    options?: RequestOptions,
  ): Promise<Array<operations.ResponseBody>> {
    return unwrapAsync(betaConversationsList(
      this,
      request,
      options,
    ));
  }

  /**
   * Retrieve a conversation information.
   *
   * @remarks
   * Given a conversation_id retrieve a conversation entity with its attributes.
   */
  async get(
    request: operations.AgentsApiV1ConversationsGetRequest,
    options?: RequestOptions,
  ): Promise<operations.AgentsApiV1ConversationsGetResponseV1ConversationsGet> {
    return unwrapAsync(betaConversationsGet(
      this,
      request,
      options,
    ));
  }

  /**
   * Append new entries to an existing conversation.
   *
   * @remarks
   * Run completion on the history of the conversation and the user entries. Return the new created entries.
   */
  async append(
    request: operations.AgentsApiV1ConversationsAppendRequest,
    options?: RequestOptions,
  ): Promise<components.ConversationResponse> {
    return unwrapAsync(betaConversationsAppend(
      this,
      request,
      options,
    ));
  }

  /**
   * Retrieve all entries in a conversation.
   *
   * @remarks
   * Given a conversation_id retrieve all the entries belonging to that conversation. The entries are sorted in the order they were appended, those can be messages, connectors or function_call.
   */
  async getHistory(
    request: operations.AgentsApiV1ConversationsHistoryRequest,
    options?: RequestOptions,
  ): Promise<components.ConversationHistory> {
    return unwrapAsync(betaConversationsGetHistory(
      this,
      request,
      options,
    ));
  }

  /**
   * Retrieve all messages in a conversation.
   *
   * @remarks
   * Given a conversation_id retrieve all the messages belonging to that conversation. This is similar to retrieving all entries except we filter the messages only.
   */
  async getMessages(
    request: operations.AgentsApiV1ConversationsMessagesRequest,
    options?: RequestOptions,
  ): Promise<components.ConversationMessages> {
    return unwrapAsync(betaConversationsGetMessages(
      this,
      request,
      options,
    ));
  }

  /**
   * Restart a conversation starting from a given entry.
   *
   * @remarks
   * Given a conversation_id and an id, recreate a conversation from this point and run completion. A new conversation is returned with the new entries returned.
   */
  async restart(
    request: operations.AgentsApiV1ConversationsRestartRequest,
    options?: RequestOptions,
  ): Promise<components.ConversationResponse> {
    return unwrapAsync(betaConversationsRestart(
      this,
      request,
      options,
    ));
  }

  /**
   * Create a conversation and append entries to it.
   *
   * @remarks
   * Create a new conversation, using a base model or an agent and append entries. Completion and tool executions are run and the response is appended to the conversation.Use the returned conversation_id to continue the conversation.
   */
  async startStream(
    request: components.ConversationStreamRequest,
    options?: RequestOptions,
  ): Promise<EventStream<components.ConversationEvents>> {
    return unwrapAsync(betaConversationsStartStream(
      this,
      request,
      options,
    ));
  }

  /**
   * Append new entries to an existing conversation.
   *
   * @remarks
   * Run completion on the history of the conversation and the user entries. Return the new created entries.
   */
  async appendStream(
    request: operations.AgentsApiV1ConversationsAppendStreamRequest,
    options?: RequestOptions,
  ): Promise<EventStream<components.ConversationEvents>> {
    return unwrapAsync(betaConversationsAppendStream(
      this,
      request,
      options,
    ));
  }

  /**
   * Restart a conversation starting from a given entry.
   *
   * @remarks
   * Given a conversation_id and an id, recreate a conversation from this point and run completion. A new conversation is returned with the new entries returned.
   */
  async restartStream(
    request: operations.AgentsApiV1ConversationsRestartStreamRequest,
    options?: RequestOptions,
  ): Promise<EventStream<components.ConversationEvents>> {
    return unwrapAsync(betaConversationsRestartStream(
      this,
      request,
      options,
    ));
  }
}
