/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export type AgentsApiV1ConversationsHistoryRequest = {
  /**
   * ID of the conversation from which we are fetching entries.
   */
  conversationId: string;
};

/** @internal */
export const AgentsApiV1ConversationsHistoryRequest$inboundSchema: z.ZodType<
  AgentsApiV1ConversationsHistoryRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  conversation_id: z.string(),
}).transform((v) => {
  return remap$(v, {
    "conversation_id": "conversationId",
  });
});

/** @internal */
export type AgentsApiV1ConversationsHistoryRequest$Outbound = {
  conversation_id: string;
};

/** @internal */
export const AgentsApiV1ConversationsHistoryRequest$outboundSchema: z.ZodType<
  AgentsApiV1ConversationsHistoryRequest$Outbound,
  z.ZodTypeDef,
  AgentsApiV1ConversationsHistoryRequest
> = z.object({
  conversationId: z.string(),
}).transform((v) => {
  return remap$(v, {
    conversationId: "conversation_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentsApiV1ConversationsHistoryRequest$ {
  /** @deprecated use `AgentsApiV1ConversationsHistoryRequest$inboundSchema` instead. */
  export const inboundSchema =
    AgentsApiV1ConversationsHistoryRequest$inboundSchema;
  /** @deprecated use `AgentsApiV1ConversationsHistoryRequest$outboundSchema` instead. */
  export const outboundSchema =
    AgentsApiV1ConversationsHistoryRequest$outboundSchema;
  /** @deprecated use `AgentsApiV1ConversationsHistoryRequest$Outbound` instead. */
  export type Outbound = AgentsApiV1ConversationsHistoryRequest$Outbound;
}

export function agentsApiV1ConversationsHistoryRequestToJSON(
  agentsApiV1ConversationsHistoryRequest:
    AgentsApiV1ConversationsHistoryRequest,
): string {
  return JSON.stringify(
    AgentsApiV1ConversationsHistoryRequest$outboundSchema.parse(
      agentsApiV1ConversationsHistoryRequest,
    ),
  );
}

export function agentsApiV1ConversationsHistoryRequestFromJSON(
  jsonString: string,
): SafeParseResult<AgentsApiV1ConversationsHistoryRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) =>
      AgentsApiV1ConversationsHistoryRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AgentsApiV1ConversationsHistoryRequest' from JSON`,
  );
}
