/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  CompletionArgs,
  CompletionArgs$inboundSchema,
  CompletionArgs$Outbound,
  CompletionArgs$outboundSchema,
} from "./completionargs.js";
import {
  ConversationInputs,
  ConversationInputs$inboundSchema,
  ConversationInputs$Outbound,
  ConversationInputs$outboundSchema,
} from "./conversationinputs.js";

export const ConversationRestartStreamRequestHandoffExecution = {
  Client: "client",
  Server: "server",
} as const;
export type ConversationRestartStreamRequestHandoffExecution = ClosedEnum<
  typeof ConversationRestartStreamRequestHandoffExecution
>;

/**
 * Request to restart a new conversation from a given entry in the conversation.
 */
export type ConversationRestartStreamRequest = {
  inputs: ConversationInputs;
  stream?: boolean | undefined;
  /**
   * Whether to store the results into our servers or not.
   */
  store?: boolean | undefined;
  handoffExecution?:
    | ConversationRestartStreamRequestHandoffExecution
    | undefined;
  /**
   * White-listed arguments from the completion API
   */
  completionArgs?: CompletionArgs | undefined;
  fromEntryId: string;
};

/** @internal */
export const ConversationRestartStreamRequestHandoffExecution$inboundSchema:
  z.ZodNativeEnum<typeof ConversationRestartStreamRequestHandoffExecution> = z
    .nativeEnum(ConversationRestartStreamRequestHandoffExecution);

/** @internal */
export const ConversationRestartStreamRequestHandoffExecution$outboundSchema:
  z.ZodNativeEnum<typeof ConversationRestartStreamRequestHandoffExecution> =
    ConversationRestartStreamRequestHandoffExecution$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationRestartStreamRequestHandoffExecution$ {
  /** @deprecated use `ConversationRestartStreamRequestHandoffExecution$inboundSchema` instead. */
  export const inboundSchema =
    ConversationRestartStreamRequestHandoffExecution$inboundSchema;
  /** @deprecated use `ConversationRestartStreamRequestHandoffExecution$outboundSchema` instead. */
  export const outboundSchema =
    ConversationRestartStreamRequestHandoffExecution$outboundSchema;
}

/** @internal */
export const ConversationRestartStreamRequest$inboundSchema: z.ZodType<
  ConversationRestartStreamRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  inputs: ConversationInputs$inboundSchema,
  stream: z.boolean().default(true),
  store: z.boolean().default(true),
  handoff_execution:
    ConversationRestartStreamRequestHandoffExecution$inboundSchema.default(
      "server",
    ),
  completion_args: CompletionArgs$inboundSchema.optional(),
  from_entry_id: z.string(),
}).transform((v) => {
  return remap$(v, {
    "handoff_execution": "handoffExecution",
    "completion_args": "completionArgs",
    "from_entry_id": "fromEntryId",
  });
});

/** @internal */
export type ConversationRestartStreamRequest$Outbound = {
  inputs: ConversationInputs$Outbound;
  stream: boolean;
  store: boolean;
  handoff_execution: string;
  completion_args?: CompletionArgs$Outbound | undefined;
  from_entry_id: string;
};

/** @internal */
export const ConversationRestartStreamRequest$outboundSchema: z.ZodType<
  ConversationRestartStreamRequest$Outbound,
  z.ZodTypeDef,
  ConversationRestartStreamRequest
> = z.object({
  inputs: ConversationInputs$outboundSchema,
  stream: z.boolean().default(true),
  store: z.boolean().default(true),
  handoffExecution:
    ConversationRestartStreamRequestHandoffExecution$outboundSchema.default(
      "server",
    ),
  completionArgs: CompletionArgs$outboundSchema.optional(),
  fromEntryId: z.string(),
}).transform((v) => {
  return remap$(v, {
    handoffExecution: "handoff_execution",
    completionArgs: "completion_args",
    fromEntryId: "from_entry_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationRestartStreamRequest$ {
  /** @deprecated use `ConversationRestartStreamRequest$inboundSchema` instead. */
  export const inboundSchema = ConversationRestartStreamRequest$inboundSchema;
  /** @deprecated use `ConversationRestartStreamRequest$outboundSchema` instead. */
  export const outboundSchema = ConversationRestartStreamRequest$outboundSchema;
  /** @deprecated use `ConversationRestartStreamRequest$Outbound` instead. */
  export type Outbound = ConversationRestartStreamRequest$Outbound;
}

export function conversationRestartStreamRequestToJSON(
  conversationRestartStreamRequest: ConversationRestartStreamRequest,
): string {
  return JSON.stringify(
    ConversationRestartStreamRequest$outboundSchema.parse(
      conversationRestartStreamRequest,
    ),
  );
}

export function conversationRestartStreamRequestFromJSON(
  jsonString: string,
): SafeParseResult<ConversationRestartStreamRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ConversationRestartStreamRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ConversationRestartStreamRequest' from JSON`,
  );
}
