/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  AgentHandoffDoneEvent,
  AgentHandoffDoneEvent$inboundSchema,
  AgentHandoffDoneEvent$Outbound,
  AgentHandoffDoneEvent$outboundSchema,
} from "./agenthandoffdoneevent.js";
import {
  AgentHandoffStartedEvent,
  AgentHandoffStartedEvent$inboundSchema,
  AgentHandoffStartedEvent$Outbound,
  AgentHandoffStartedEvent$outboundSchema,
} from "./agenthandoffstartedevent.js";
import {
  FunctionCallEvent,
  FunctionCallEvent$inboundSchema,
  FunctionCallEvent$Outbound,
  FunctionCallEvent$outboundSchema,
} from "./functioncallevent.js";
import {
  MessageOutputEvent,
  MessageOutputEvent$inboundSchema,
  MessageOutputEvent$Outbound,
  MessageOutputEvent$outboundSchema,
} from "./messageoutputevent.js";
import {
  ResponseDoneEvent,
  ResponseDoneEvent$inboundSchema,
  ResponseDoneEvent$Outbound,
  ResponseDoneEvent$outboundSchema,
} from "./responsedoneevent.js";
import {
  ResponseErrorEvent,
  ResponseErrorEvent$inboundSchema,
  ResponseErrorEvent$Outbound,
  ResponseErrorEvent$outboundSchema,
} from "./responseerrorevent.js";
import {
  ResponseStartedEvent,
  ResponseStartedEvent$inboundSchema,
  ResponseStartedEvent$Outbound,
  ResponseStartedEvent$outboundSchema,
} from "./responsestartedevent.js";
import {
  SSETypes,
  SSETypes$inboundSchema,
  SSETypes$outboundSchema,
} from "./ssetypes.js";
import {
  ToolExecutionDeltaEvent,
  ToolExecutionDeltaEvent$inboundSchema,
  ToolExecutionDeltaEvent$Outbound,
  ToolExecutionDeltaEvent$outboundSchema,
} from "./toolexecutiondeltaevent.js";
import {
  ToolExecutionDoneEvent,
  ToolExecutionDoneEvent$inboundSchema,
  ToolExecutionDoneEvent$Outbound,
  ToolExecutionDoneEvent$outboundSchema,
} from "./toolexecutiondoneevent.js";
import {
  ToolExecutionStartedEvent,
  ToolExecutionStartedEvent$inboundSchema,
  ToolExecutionStartedEvent$Outbound,
  ToolExecutionStartedEvent$outboundSchema,
} from "./toolexecutionstartedevent.js";

export type ConversationEventsData =
  | (FunctionCallEvent & { type: "function.call.delta" })
  | (AgentHandoffDoneEvent & { type: "agent.handoff.done" })
  | (AgentHandoffStartedEvent & { type: "agent.handoff.started" })
  | (ToolExecutionDeltaEvent & { type: "tool.execution.delta" })
  | (ToolExecutionStartedEvent & { type: "tool.execution.started" })
  | (ResponseErrorEvent & { type: "conversation.response.error" })
  | (MessageOutputEvent & { type: "message.output.delta" })
  | (ToolExecutionDoneEvent & { type: "tool.execution.done" })
  | (ResponseDoneEvent & { type: "conversation.response.done" })
  | (ResponseStartedEvent & { type: "conversation.response.started" });

export type ConversationEvents = {
  /**
   * Server side events sent when streaming a conversation response.
   */
  event: SSETypes;
  data:
    | (FunctionCallEvent & { type: "function.call.delta" })
    | (AgentHandoffDoneEvent & { type: "agent.handoff.done" })
    | (AgentHandoffStartedEvent & { type: "agent.handoff.started" })
    | (ToolExecutionDeltaEvent & { type: "tool.execution.delta" })
    | (ToolExecutionStartedEvent & { type: "tool.execution.started" })
    | (ResponseErrorEvent & { type: "conversation.response.error" })
    | (MessageOutputEvent & { type: "message.output.delta" })
    | (ToolExecutionDoneEvent & { type: "tool.execution.done" })
    | (ResponseDoneEvent & { type: "conversation.response.done" })
    | (ResponseStartedEvent & { type: "conversation.response.started" });
};

/** @internal */
export const ConversationEventsData$inboundSchema: z.ZodType<
  ConversationEventsData,
  z.ZodTypeDef,
  unknown
> = z.union([
  FunctionCallEvent$inboundSchema.and(
    z.object({ type: z.literal("function.call.delta") }).transform((v) => ({
      type: v.type,
    })),
  ),
  AgentHandoffDoneEvent$inboundSchema.and(
    z.object({ type: z.literal("agent.handoff.done") }).transform((v) => ({
      type: v.type,
    })),
  ),
  AgentHandoffStartedEvent$inboundSchema.and(
    z.object({ type: z.literal("agent.handoff.started") }).transform((v) => ({
      type: v.type,
    })),
  ),
  ToolExecutionDeltaEvent$inboundSchema.and(
    z.object({ type: z.literal("tool.execution.delta") }).transform((v) => ({
      type: v.type,
    })),
  ),
  ToolExecutionStartedEvent$inboundSchema.and(
    z.object({ type: z.literal("tool.execution.started") }).transform((v) => ({
      type: v.type,
    })),
  ),
  ResponseErrorEvent$inboundSchema.and(
    z.object({ type: z.literal("conversation.response.error") }).transform((
      v,
    ) => ({ type: v.type })),
  ),
  MessageOutputEvent$inboundSchema.and(
    z.object({ type: z.literal("message.output.delta") }).transform((v) => ({
      type: v.type,
    })),
  ),
  ToolExecutionDoneEvent$inboundSchema.and(
    z.object({ type: z.literal("tool.execution.done") }).transform((v) => ({
      type: v.type,
    })),
  ),
  ResponseDoneEvent$inboundSchema.and(
    z.object({ type: z.literal("conversation.response.done") }).transform((
      v,
    ) => ({ type: v.type })),
  ),
  ResponseStartedEvent$inboundSchema.and(
    z.object({ type: z.literal("conversation.response.started") }).transform((
      v,
    ) => ({ type: v.type })),
  ),
]);

/** @internal */
export type ConversationEventsData$Outbound =
  | (FunctionCallEvent$Outbound & { type: "function.call.delta" })
  | (AgentHandoffDoneEvent$Outbound & { type: "agent.handoff.done" })
  | (AgentHandoffStartedEvent$Outbound & { type: "agent.handoff.started" })
  | (ToolExecutionDeltaEvent$Outbound & { type: "tool.execution.delta" })
  | (ToolExecutionStartedEvent$Outbound & { type: "tool.execution.started" })
  | (ResponseErrorEvent$Outbound & { type: "conversation.response.error" })
  | (MessageOutputEvent$Outbound & { type: "message.output.delta" })
  | (ToolExecutionDoneEvent$Outbound & { type: "tool.execution.done" })
  | (ResponseDoneEvent$Outbound & { type: "conversation.response.done" })
  | (ResponseStartedEvent$Outbound & { type: "conversation.response.started" });

/** @internal */
export const ConversationEventsData$outboundSchema: z.ZodType<
  ConversationEventsData$Outbound,
  z.ZodTypeDef,
  ConversationEventsData
> = z.union([
  FunctionCallEvent$outboundSchema.and(
    z.object({ type: z.literal("function.call.delta") }).transform((v) => ({
      type: v.type,
    })),
  ),
  AgentHandoffDoneEvent$outboundSchema.and(
    z.object({ type: z.literal("agent.handoff.done") }).transform((v) => ({
      type: v.type,
    })),
  ),
  AgentHandoffStartedEvent$outboundSchema.and(
    z.object({ type: z.literal("agent.handoff.started") }).transform((v) => ({
      type: v.type,
    })),
  ),
  ToolExecutionDeltaEvent$outboundSchema.and(
    z.object({ type: z.literal("tool.execution.delta") }).transform((v) => ({
      type: v.type,
    })),
  ),
  ToolExecutionStartedEvent$outboundSchema.and(
    z.object({ type: z.literal("tool.execution.started") }).transform((v) => ({
      type: v.type,
    })),
  ),
  ResponseErrorEvent$outboundSchema.and(
    z.object({ type: z.literal("conversation.response.error") }).transform((
      v,
    ) => ({ type: v.type })),
  ),
  MessageOutputEvent$outboundSchema.and(
    z.object({ type: z.literal("message.output.delta") }).transform((v) => ({
      type: v.type,
    })),
  ),
  ToolExecutionDoneEvent$outboundSchema.and(
    z.object({ type: z.literal("tool.execution.done") }).transform((v) => ({
      type: v.type,
    })),
  ),
  ResponseDoneEvent$outboundSchema.and(
    z.object({ type: z.literal("conversation.response.done") }).transform((
      v,
    ) => ({ type: v.type })),
  ),
  ResponseStartedEvent$outboundSchema.and(
    z.object({ type: z.literal("conversation.response.started") }).transform((
      v,
    ) => ({ type: v.type })),
  ),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationEventsData$ {
  /** @deprecated use `ConversationEventsData$inboundSchema` instead. */
  export const inboundSchema = ConversationEventsData$inboundSchema;
  /** @deprecated use `ConversationEventsData$outboundSchema` instead. */
  export const outboundSchema = ConversationEventsData$outboundSchema;
  /** @deprecated use `ConversationEventsData$Outbound` instead. */
  export type Outbound = ConversationEventsData$Outbound;
}

export function conversationEventsDataToJSON(
  conversationEventsData: ConversationEventsData,
): string {
  return JSON.stringify(
    ConversationEventsData$outboundSchema.parse(conversationEventsData),
  );
}

export function conversationEventsDataFromJSON(
  jsonString: string,
): SafeParseResult<ConversationEventsData, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ConversationEventsData$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ConversationEventsData' from JSON`,
  );
}

/** @internal */
export const ConversationEvents$inboundSchema: z.ZodType<
  ConversationEvents,
  z.ZodTypeDef,
  unknown
> = z.object({
  event: SSETypes$inboundSchema,
  data: z.string().transform((v, ctx) => {
    try {
      return JSON.parse(v);
    } catch (err) {
      ctx.addIssue({
        code: z.ZodIssueCode.custom,
        message: `malformed json: ${err}`,
      });
      return z.NEVER;
    }
  }).pipe(
    z.union([
      FunctionCallEvent$inboundSchema.and(
        z.object({ type: z.literal("function.call.delta") }).transform((v) => ({
          type: v.type,
        })),
      ),
      AgentHandoffDoneEvent$inboundSchema.and(
        z.object({ type: z.literal("agent.handoff.done") }).transform((v) => ({
          type: v.type,
        })),
      ),
      AgentHandoffStartedEvent$inboundSchema.and(
        z.object({ type: z.literal("agent.handoff.started") }).transform((
          v,
        ) => ({ type: v.type })),
      ),
      ToolExecutionDeltaEvent$inboundSchema.and(
        z.object({ type: z.literal("tool.execution.delta") }).transform((
          v,
        ) => ({ type: v.type })),
      ),
      ToolExecutionStartedEvent$inboundSchema.and(
        z.object({ type: z.literal("tool.execution.started") }).transform((
          v,
        ) => ({ type: v.type })),
      ),
      ResponseErrorEvent$inboundSchema.and(
        z.object({ type: z.literal("conversation.response.error") }).transform((
          v,
        ) => ({ type: v.type })),
      ),
      MessageOutputEvent$inboundSchema.and(
        z.object({ type: z.literal("message.output.delta") }).transform((
          v,
        ) => ({ type: v.type })),
      ),
      ToolExecutionDoneEvent$inboundSchema.and(
        z.object({ type: z.literal("tool.execution.done") }).transform((v) => ({
          type: v.type,
        })),
      ),
      ResponseDoneEvent$inboundSchema.and(
        z.object({ type: z.literal("conversation.response.done") }).transform((
          v,
        ) => ({ type: v.type })),
      ),
      ResponseStartedEvent$inboundSchema.and(
        z.object({ type: z.literal("conversation.response.started") })
          .transform((v) => ({ type: v.type })),
      ),
    ]),
  ),
});

/** @internal */
export type ConversationEvents$Outbound = {
  event: string;
  data:
    | (FunctionCallEvent$Outbound & { type: "function.call.delta" })
    | (AgentHandoffDoneEvent$Outbound & { type: "agent.handoff.done" })
    | (AgentHandoffStartedEvent$Outbound & { type: "agent.handoff.started" })
    | (ToolExecutionDeltaEvent$Outbound & { type: "tool.execution.delta" })
    | (ToolExecutionStartedEvent$Outbound & { type: "tool.execution.started" })
    | (ResponseErrorEvent$Outbound & { type: "conversation.response.error" })
    | (MessageOutputEvent$Outbound & { type: "message.output.delta" })
    | (ToolExecutionDoneEvent$Outbound & { type: "tool.execution.done" })
    | (ResponseDoneEvent$Outbound & { type: "conversation.response.done" })
    | (ResponseStartedEvent$Outbound & {
      type: "conversation.response.started";
    });
};

/** @internal */
export const ConversationEvents$outboundSchema: z.ZodType<
  ConversationEvents$Outbound,
  z.ZodTypeDef,
  ConversationEvents
> = z.object({
  event: SSETypes$outboundSchema,
  data: z.union([
    FunctionCallEvent$outboundSchema.and(
      z.object({ type: z.literal("function.call.delta") }).transform((v) => ({
        type: v.type,
      })),
    ),
    AgentHandoffDoneEvent$outboundSchema.and(
      z.object({ type: z.literal("agent.handoff.done") }).transform((v) => ({
        type: v.type,
      })),
    ),
    AgentHandoffStartedEvent$outboundSchema.and(
      z.object({ type: z.literal("agent.handoff.started") }).transform((v) => ({
        type: v.type,
      })),
    ),
    ToolExecutionDeltaEvent$outboundSchema.and(
      z.object({ type: z.literal("tool.execution.delta") }).transform((v) => ({
        type: v.type,
      })),
    ),
    ToolExecutionStartedEvent$outboundSchema.and(
      z.object({ type: z.literal("tool.execution.started") }).transform((
        v,
      ) => ({ type: v.type })),
    ),
    ResponseErrorEvent$outboundSchema.and(
      z.object({ type: z.literal("conversation.response.error") }).transform((
        v,
      ) => ({ type: v.type })),
    ),
    MessageOutputEvent$outboundSchema.and(
      z.object({ type: z.literal("message.output.delta") }).transform((v) => ({
        type: v.type,
      })),
    ),
    ToolExecutionDoneEvent$outboundSchema.and(
      z.object({ type: z.literal("tool.execution.done") }).transform((v) => ({
        type: v.type,
      })),
    ),
    ResponseDoneEvent$outboundSchema.and(
      z.object({ type: z.literal("conversation.response.done") }).transform((
        v,
      ) => ({ type: v.type })),
    ),
    ResponseStartedEvent$outboundSchema.and(
      z.object({ type: z.literal("conversation.response.started") }).transform((
        v,
      ) => ({ type: v.type })),
    ),
  ]),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationEvents$ {
  /** @deprecated use `ConversationEvents$inboundSchema` instead. */
  export const inboundSchema = ConversationEvents$inboundSchema;
  /** @deprecated use `ConversationEvents$outboundSchema` instead. */
  export const outboundSchema = ConversationEvents$outboundSchema;
  /** @deprecated use `ConversationEvents$Outbound` instead. */
  export type Outbound = ConversationEvents$Outbound;
}

export function conversationEventsToJSON(
  conversationEvents: ConversationEvents,
): string {
  return JSON.stringify(
    ConversationEvents$outboundSchema.parse(conversationEvents),
  );
}

export function conversationEventsFromJSON(
  jsonString: string,
): SafeParseResult<ConversationEvents, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ConversationEvents$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ConversationEvents' from JSON`,
  );
}
