/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  CompletionArgs,
  CompletionArgs$inboundSchema,
  CompletionArgs$Outbound,
  CompletionArgs$outboundSchema,
} from "./completionargs.js";
import {
  ConversationInputs,
  ConversationInputs$inboundSchema,
  ConversationInputs$Outbound,
  ConversationInputs$outboundSchema,
} from "./conversationinputs.js";

export const ConversationAppendRequestHandoffExecution = {
  Client: "client",
  Server: "server",
} as const;
export type ConversationAppendRequestHandoffExecution = ClosedEnum<
  typeof ConversationAppendRequestHandoffExecution
>;

export type ConversationAppendRequest = {
  inputs: ConversationInputs;
  stream?: boolean | undefined;
  /**
   * Whether to store the results into our servers or not.
   */
  store?: boolean | undefined;
  handoffExecution?: ConversationAppendRequestHandoffExecution | undefined;
  /**
   * White-listed arguments from the completion API
   */
  completionArgs?: CompletionArgs | undefined;
};

/** @internal */
export const ConversationAppendRequestHandoffExecution$inboundSchema:
  z.ZodNativeEnum<typeof ConversationAppendRequestHandoffExecution> = z
    .nativeEnum(ConversationAppendRequestHandoffExecution);

/** @internal */
export const ConversationAppendRequestHandoffExecution$outboundSchema:
  z.ZodNativeEnum<typeof ConversationAppendRequestHandoffExecution> =
    ConversationAppendRequestHandoffExecution$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationAppendRequestHandoffExecution$ {
  /** @deprecated use `ConversationAppendRequestHandoffExecution$inboundSchema` instead. */
  export const inboundSchema =
    ConversationAppendRequestHandoffExecution$inboundSchema;
  /** @deprecated use `ConversationAppendRequestHandoffExecution$outboundSchema` instead. */
  export const outboundSchema =
    ConversationAppendRequestHandoffExecution$outboundSchema;
}

/** @internal */
export const ConversationAppendRequest$inboundSchema: z.ZodType<
  ConversationAppendRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  inputs: ConversationInputs$inboundSchema,
  stream: z.boolean().default(false),
  store: z.boolean().default(true),
  handoff_execution: ConversationAppendRequestHandoffExecution$inboundSchema
    .default("server"),
  completion_args: CompletionArgs$inboundSchema.optional(),
}).transform((v) => {
  return remap$(v, {
    "handoff_execution": "handoffExecution",
    "completion_args": "completionArgs",
  });
});

/** @internal */
export type ConversationAppendRequest$Outbound = {
  inputs: ConversationInputs$Outbound;
  stream: boolean;
  store: boolean;
  handoff_execution: string;
  completion_args?: CompletionArgs$Outbound | undefined;
};

/** @internal */
export const ConversationAppendRequest$outboundSchema: z.ZodType<
  ConversationAppendRequest$Outbound,
  z.ZodTypeDef,
  ConversationAppendRequest
> = z.object({
  inputs: ConversationInputs$outboundSchema,
  stream: z.boolean().default(false),
  store: z.boolean().default(true),
  handoffExecution: ConversationAppendRequestHandoffExecution$outboundSchema
    .default("server"),
  completionArgs: CompletionArgs$outboundSchema.optional(),
}).transform((v) => {
  return remap$(v, {
    handoffExecution: "handoff_execution",
    completionArgs: "completion_args",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationAppendRequest$ {
  /** @deprecated use `ConversationAppendRequest$inboundSchema` instead. */
  export const inboundSchema = ConversationAppendRequest$inboundSchema;
  /** @deprecated use `ConversationAppendRequest$outboundSchema` instead. */
  export const outboundSchema = ConversationAppendRequest$outboundSchema;
  /** @deprecated use `ConversationAppendRequest$Outbound` instead. */
  export type Outbound = ConversationAppendRequest$Outbound;
}

export function conversationAppendRequestToJSON(
  conversationAppendRequest: ConversationAppendRequest,
): string {
  return JSON.stringify(
    ConversationAppendRequest$outboundSchema.parse(conversationAppendRequest),
  );
}

export function conversationAppendRequestFromJSON(
  jsonString: string,
): SafeParseResult<ConversationAppendRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ConversationAppendRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ConversationAppendRequest' from JSON`,
  );
}
