/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

/**
 * Text to classify.
 */
export type ClassificationRequestInputs = string | Array<string>;

export type ClassificationRequest = {
  /**
   * ID of the model to use.
   */
  model: string;
  /**
   * Text to classify.
   */
  inputs: string | Array<string>;
};

/** @internal */
export const ClassificationRequestInputs$inboundSchema: z.ZodType<
  ClassificationRequestInputs,
  z.ZodTypeDef,
  unknown
> = z.union([z.string(), z.array(z.string())]);

/** @internal */
export type ClassificationRequestInputs$Outbound = string | Array<string>;

/** @internal */
export const ClassificationRequestInputs$outboundSchema: z.ZodType<
  ClassificationRequestInputs$Outbound,
  z.ZodTypeDef,
  ClassificationRequestInputs
> = z.union([z.string(), z.array(z.string())]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ClassificationRequestInputs$ {
  /** @deprecated use `ClassificationRequestInputs$inboundSchema` instead. */
  export const inboundSchema = ClassificationRequestInputs$inboundSchema;
  /** @deprecated use `ClassificationRequestInputs$outboundSchema` instead. */
  export const outboundSchema = ClassificationRequestInputs$outboundSchema;
  /** @deprecated use `ClassificationRequestInputs$Outbound` instead. */
  export type Outbound = ClassificationRequestInputs$Outbound;
}

export function classificationRequestInputsToJSON(
  classificationRequestInputs: ClassificationRequestInputs,
): string {
  return JSON.stringify(
    ClassificationRequestInputs$outboundSchema.parse(
      classificationRequestInputs,
    ),
  );
}

export function classificationRequestInputsFromJSON(
  jsonString: string,
): SafeParseResult<ClassificationRequestInputs, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ClassificationRequestInputs$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ClassificationRequestInputs' from JSON`,
  );
}

/** @internal */
export const ClassificationRequest$inboundSchema: z.ZodType<
  ClassificationRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  model: z.string(),
  input: z.union([z.string(), z.array(z.string())]),
}).transform((v) => {
  return remap$(v, {
    "input": "inputs",
  });
});

/** @internal */
export type ClassificationRequest$Outbound = {
  model: string;
  input: string | Array<string>;
};

/** @internal */
export const ClassificationRequest$outboundSchema: z.ZodType<
  ClassificationRequest$Outbound,
  z.ZodTypeDef,
  ClassificationRequest
> = z.object({
  model: z.string(),
  inputs: z.union([z.string(), z.array(z.string())]),
}).transform((v) => {
  return remap$(v, {
    inputs: "input",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ClassificationRequest$ {
  /** @deprecated use `ClassificationRequest$inboundSchema` instead. */
  export const inboundSchema = ClassificationRequest$inboundSchema;
  /** @deprecated use `ClassificationRequest$outboundSchema` instead. */
  export const outboundSchema = ClassificationRequest$outboundSchema;
  /** @deprecated use `ClassificationRequest$Outbound` instead. */
  export type Outbound = ClassificationRequest$Outbound;
}

export function classificationRequestToJSON(
  classificationRequest: ClassificationRequest,
): string {
  return JSON.stringify(
    ClassificationRequest$outboundSchema.parse(classificationRequest),
  );
}

export function classificationRequestFromJSON(
  jsonString: string,
): SafeParseResult<ClassificationRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ClassificationRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ClassificationRequest' from JSON`,
  );
}
