/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  AssistantMessage,
  AssistantMessage$inboundSchema,
  AssistantMessage$Outbound,
  AssistantMessage$outboundSchema,
} from "./assistantmessage.js";
import {
  SystemMessage,
  SystemMessage$inboundSchema,
  SystemMessage$Outbound,
  SystemMessage$outboundSchema,
} from "./systemmessage.js";
import {
  ToolMessage,
  ToolMessage$inboundSchema,
  ToolMessage$Outbound,
  ToolMessage$outboundSchema,
} from "./toolmessage.js";
import {
  UserMessage,
  UserMessage$inboundSchema,
  UserMessage$Outbound,
  UserMessage$outboundSchema,
} from "./usermessage.js";

export type Two =
  | (SystemMessage & { role: "system" })
  | (ToolMessage & { role: "tool" })
  | (UserMessage & { role: "user" })
  | (AssistantMessage & { role: "assistant" });

export type One =
  | (SystemMessage & { role: "system" })
  | (ToolMessage & { role: "tool" })
  | (UserMessage & { role: "user" })
  | (AssistantMessage & { role: "assistant" });

/**
 * Chat to classify
 */
export type ChatModerationRequestInputs =
  | Array<
    | (SystemMessage & { role: "system" })
    | (ToolMessage & { role: "tool" })
    | (UserMessage & { role: "user" })
    | (AssistantMessage & { role: "assistant" })
  >
  | Array<
    Array<
      | (SystemMessage & { role: "system" })
      | (ToolMessage & { role: "tool" })
      | (UserMessage & { role: "user" })
      | (AssistantMessage & { role: "assistant" })
    >
  >;

export type ChatModerationRequest = {
  /**
   * Chat to classify
   */
  inputs:
    | Array<
      | (SystemMessage & { role: "system" })
      | (ToolMessage & { role: "tool" })
      | (UserMessage & { role: "user" })
      | (AssistantMessage & { role: "assistant" })
    >
    | Array<
      Array<
        | (SystemMessage & { role: "system" })
        | (ToolMessage & { role: "tool" })
        | (UserMessage & { role: "user" })
        | (AssistantMessage & { role: "assistant" })
      >
    >;
  model: string;
};

/** @internal */
export const Two$inboundSchema: z.ZodType<Two, z.ZodTypeDef, unknown> = z.union(
  [
    SystemMessage$inboundSchema.and(
      z.object({ role: z.literal("system") }).transform((v) => ({
        role: v.role,
      })),
    ),
    ToolMessage$inboundSchema.and(
      z.object({ role: z.literal("tool") }).transform((v) => ({
        role: v.role,
      })),
    ),
    UserMessage$inboundSchema.and(
      z.object({ role: z.literal("user") }).transform((v) => ({
        role: v.role,
      })),
    ),
    AssistantMessage$inboundSchema.and(
      z.object({ role: z.literal("assistant") }).transform((v) => ({
        role: v.role,
      })),
    ),
  ],
);

/** @internal */
export type Two$Outbound =
  | (SystemMessage$Outbound & { role: "system" })
  | (ToolMessage$Outbound & { role: "tool" })
  | (UserMessage$Outbound & { role: "user" })
  | (AssistantMessage$Outbound & { role: "assistant" });

/** @internal */
export const Two$outboundSchema: z.ZodType<Two$Outbound, z.ZodTypeDef, Two> = z
  .union([
    SystemMessage$outboundSchema.and(
      z.object({ role: z.literal("system") }).transform((v) => ({
        role: v.role,
      })),
    ),
    ToolMessage$outboundSchema.and(
      z.object({ role: z.literal("tool") }).transform((v) => ({
        role: v.role,
      })),
    ),
    UserMessage$outboundSchema.and(
      z.object({ role: z.literal("user") }).transform((v) => ({
        role: v.role,
      })),
    ),
    AssistantMessage$outboundSchema.and(
      z.object({ role: z.literal("assistant") }).transform((v) => ({
        role: v.role,
      })),
    ),
  ]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Two$ {
  /** @deprecated use `Two$inboundSchema` instead. */
  export const inboundSchema = Two$inboundSchema;
  /** @deprecated use `Two$outboundSchema` instead. */
  export const outboundSchema = Two$outboundSchema;
  /** @deprecated use `Two$Outbound` instead. */
  export type Outbound = Two$Outbound;
}

export function twoToJSON(two: Two): string {
  return JSON.stringify(Two$outboundSchema.parse(two));
}

export function twoFromJSON(
  jsonString: string,
): SafeParseResult<Two, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => Two$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'Two' from JSON`,
  );
}

/** @internal */
export const One$inboundSchema: z.ZodType<One, z.ZodTypeDef, unknown> = z.union(
  [
    SystemMessage$inboundSchema.and(
      z.object({ role: z.literal("system") }).transform((v) => ({
        role: v.role,
      })),
    ),
    ToolMessage$inboundSchema.and(
      z.object({ role: z.literal("tool") }).transform((v) => ({
        role: v.role,
      })),
    ),
    UserMessage$inboundSchema.and(
      z.object({ role: z.literal("user") }).transform((v) => ({
        role: v.role,
      })),
    ),
    AssistantMessage$inboundSchema.and(
      z.object({ role: z.literal("assistant") }).transform((v) => ({
        role: v.role,
      })),
    ),
  ],
);

/** @internal */
export type One$Outbound =
  | (SystemMessage$Outbound & { role: "system" })
  | (ToolMessage$Outbound & { role: "tool" })
  | (UserMessage$Outbound & { role: "user" })
  | (AssistantMessage$Outbound & { role: "assistant" });

/** @internal */
export const One$outboundSchema: z.ZodType<One$Outbound, z.ZodTypeDef, One> = z
  .union([
    SystemMessage$outboundSchema.and(
      z.object({ role: z.literal("system") }).transform((v) => ({
        role: v.role,
      })),
    ),
    ToolMessage$outboundSchema.and(
      z.object({ role: z.literal("tool") }).transform((v) => ({
        role: v.role,
      })),
    ),
    UserMessage$outboundSchema.and(
      z.object({ role: z.literal("user") }).transform((v) => ({
        role: v.role,
      })),
    ),
    AssistantMessage$outboundSchema.and(
      z.object({ role: z.literal("assistant") }).transform((v) => ({
        role: v.role,
      })),
    ),
  ]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace One$ {
  /** @deprecated use `One$inboundSchema` instead. */
  export const inboundSchema = One$inboundSchema;
  /** @deprecated use `One$outboundSchema` instead. */
  export const outboundSchema = One$outboundSchema;
  /** @deprecated use `One$Outbound` instead. */
  export type Outbound = One$Outbound;
}

export function oneToJSON(one: One): string {
  return JSON.stringify(One$outboundSchema.parse(one));
}

export function oneFromJSON(
  jsonString: string,
): SafeParseResult<One, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => One$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'One' from JSON`,
  );
}

/** @internal */
export const ChatModerationRequestInputs$inboundSchema: z.ZodType<
  ChatModerationRequestInputs,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.array(
    z.union([
      SystemMessage$inboundSchema.and(
        z.object({ role: z.literal("system") }).transform((v) => ({
          role: v.role,
        })),
      ),
      ToolMessage$inboundSchema.and(
        z.object({ role: z.literal("tool") }).transform((v) => ({
          role: v.role,
        })),
      ),
      UserMessage$inboundSchema.and(
        z.object({ role: z.literal("user") }).transform((v) => ({
          role: v.role,
        })),
      ),
      AssistantMessage$inboundSchema.and(
        z.object({ role: z.literal("assistant") }).transform((v) => ({
          role: v.role,
        })),
      ),
    ]),
  ),
  z.array(
    z.array(
      z.union([
        SystemMessage$inboundSchema.and(
          z.object({ role: z.literal("system") }).transform((v) => ({
            role: v.role,
          })),
        ),
        ToolMessage$inboundSchema.and(
          z.object({ role: z.literal("tool") }).transform((v) => ({
            role: v.role,
          })),
        ),
        UserMessage$inboundSchema.and(
          z.object({ role: z.literal("user") }).transform((v) => ({
            role: v.role,
          })),
        ),
        AssistantMessage$inboundSchema.and(
          z.object({ role: z.literal("assistant") }).transform((v) => ({
            role: v.role,
          })),
        ),
      ]),
    ),
  ),
]);

/** @internal */
export type ChatModerationRequestInputs$Outbound =
  | Array<
    | (SystemMessage$Outbound & { role: "system" })
    | (ToolMessage$Outbound & { role: "tool" })
    | (UserMessage$Outbound & { role: "user" })
    | (AssistantMessage$Outbound & { role: "assistant" })
  >
  | Array<
    Array<
      | (SystemMessage$Outbound & { role: "system" })
      | (ToolMessage$Outbound & { role: "tool" })
      | (UserMessage$Outbound & { role: "user" })
      | (AssistantMessage$Outbound & { role: "assistant" })
    >
  >;

/** @internal */
export const ChatModerationRequestInputs$outboundSchema: z.ZodType<
  ChatModerationRequestInputs$Outbound,
  z.ZodTypeDef,
  ChatModerationRequestInputs
> = z.union([
  z.array(
    z.union([
      SystemMessage$outboundSchema.and(
        z.object({ role: z.literal("system") }).transform((v) => ({
          role: v.role,
        })),
      ),
      ToolMessage$outboundSchema.and(
        z.object({ role: z.literal("tool") }).transform((v) => ({
          role: v.role,
        })),
      ),
      UserMessage$outboundSchema.and(
        z.object({ role: z.literal("user") }).transform((v) => ({
          role: v.role,
        })),
      ),
      AssistantMessage$outboundSchema.and(
        z.object({ role: z.literal("assistant") }).transform((v) => ({
          role: v.role,
        })),
      ),
    ]),
  ),
  z.array(
    z.array(
      z.union([
        SystemMessage$outboundSchema.and(
          z.object({ role: z.literal("system") }).transform((v) => ({
            role: v.role,
          })),
        ),
        ToolMessage$outboundSchema.and(
          z.object({ role: z.literal("tool") }).transform((v) => ({
            role: v.role,
          })),
        ),
        UserMessage$outboundSchema.and(
          z.object({ role: z.literal("user") }).transform((v) => ({
            role: v.role,
          })),
        ),
        AssistantMessage$outboundSchema.and(
          z.object({ role: z.literal("assistant") }).transform((v) => ({
            role: v.role,
          })),
        ),
      ]),
    ),
  ),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ChatModerationRequestInputs$ {
  /** @deprecated use `ChatModerationRequestInputs$inboundSchema` instead. */
  export const inboundSchema = ChatModerationRequestInputs$inboundSchema;
  /** @deprecated use `ChatModerationRequestInputs$outboundSchema` instead. */
  export const outboundSchema = ChatModerationRequestInputs$outboundSchema;
  /** @deprecated use `ChatModerationRequestInputs$Outbound` instead. */
  export type Outbound = ChatModerationRequestInputs$Outbound;
}

export function chatModerationRequestInputsToJSON(
  chatModerationRequestInputs: ChatModerationRequestInputs,
): string {
  return JSON.stringify(
    ChatModerationRequestInputs$outboundSchema.parse(
      chatModerationRequestInputs,
    ),
  );
}

export function chatModerationRequestInputsFromJSON(
  jsonString: string,
): SafeParseResult<ChatModerationRequestInputs, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ChatModerationRequestInputs$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ChatModerationRequestInputs' from JSON`,
  );
}

/** @internal */
export const ChatModerationRequest$inboundSchema: z.ZodType<
  ChatModerationRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  input: z.union([
    z.array(
      z.union([
        SystemMessage$inboundSchema.and(
          z.object({ role: z.literal("system") }).transform((v) => ({
            role: v.role,
          })),
        ),
        ToolMessage$inboundSchema.and(
          z.object({ role: z.literal("tool") }).transform((v) => ({
            role: v.role,
          })),
        ),
        UserMessage$inboundSchema.and(
          z.object({ role: z.literal("user") }).transform((v) => ({
            role: v.role,
          })),
        ),
        AssistantMessage$inboundSchema.and(
          z.object({ role: z.literal("assistant") }).transform((v) => ({
            role: v.role,
          })),
        ),
      ]),
    ),
    z.array(
      z.array(
        z.union([
          SystemMessage$inboundSchema.and(
            z.object({ role: z.literal("system") }).transform((v) => ({
              role: v.role,
            })),
          ),
          ToolMessage$inboundSchema.and(
            z.object({ role: z.literal("tool") }).transform((v) => ({
              role: v.role,
            })),
          ),
          UserMessage$inboundSchema.and(
            z.object({ role: z.literal("user") }).transform((v) => ({
              role: v.role,
            })),
          ),
          AssistantMessage$inboundSchema.and(
            z.object({ role: z.literal("assistant") }).transform((v) => ({
              role: v.role,
            })),
          ),
        ]),
      ),
    ),
  ]),
  model: z.string(),
}).transform((v) => {
  return remap$(v, {
    "input": "inputs",
  });
});

/** @internal */
export type ChatModerationRequest$Outbound = {
  input:
    | Array<
      | (SystemMessage$Outbound & { role: "system" })
      | (ToolMessage$Outbound & { role: "tool" })
      | (UserMessage$Outbound & { role: "user" })
      | (AssistantMessage$Outbound & { role: "assistant" })
    >
    | Array<
      Array<
        | (SystemMessage$Outbound & { role: "system" })
        | (ToolMessage$Outbound & { role: "tool" })
        | (UserMessage$Outbound & { role: "user" })
        | (AssistantMessage$Outbound & { role: "assistant" })
      >
    >;
  model: string;
};

/** @internal */
export const ChatModerationRequest$outboundSchema: z.ZodType<
  ChatModerationRequest$Outbound,
  z.ZodTypeDef,
  ChatModerationRequest
> = z.object({
  inputs: z.union([
    z.array(
      z.union([
        SystemMessage$outboundSchema.and(
          z.object({ role: z.literal("system") }).transform((v) => ({
            role: v.role,
          })),
        ),
        ToolMessage$outboundSchema.and(
          z.object({ role: z.literal("tool") }).transform((v) => ({
            role: v.role,
          })),
        ),
        UserMessage$outboundSchema.and(
          z.object({ role: z.literal("user") }).transform((v) => ({
            role: v.role,
          })),
        ),
        AssistantMessage$outboundSchema.and(
          z.object({ role: z.literal("assistant") }).transform((v) => ({
            role: v.role,
          })),
        ),
      ]),
    ),
    z.array(
      z.array(
        z.union([
          SystemMessage$outboundSchema.and(
            z.object({ role: z.literal("system") }).transform((v) => ({
              role: v.role,
            })),
          ),
          ToolMessage$outboundSchema.and(
            z.object({ role: z.literal("tool") }).transform((v) => ({
              role: v.role,
            })),
          ),
          UserMessage$outboundSchema.and(
            z.object({ role: z.literal("user") }).transform((v) => ({
              role: v.role,
            })),
          ),
          AssistantMessage$outboundSchema.and(
            z.object({ role: z.literal("assistant") }).transform((v) => ({
              role: v.role,
            })),
          ),
        ]),
      ),
    ),
  ]),
  model: z.string(),
}).transform((v) => {
  return remap$(v, {
    inputs: "input",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ChatModerationRequest$ {
  /** @deprecated use `ChatModerationRequest$inboundSchema` instead. */
  export const inboundSchema = ChatModerationRequest$inboundSchema;
  /** @deprecated use `ChatModerationRequest$outboundSchema` instead. */
  export const outboundSchema = ChatModerationRequest$outboundSchema;
  /** @deprecated use `ChatModerationRequest$Outbound` instead. */
  export type Outbound = ChatModerationRequest$Outbound;
}

export function chatModerationRequestToJSON(
  chatModerationRequest: ChatModerationRequest,
): string {
  return JSON.stringify(
    ChatModerationRequest$outboundSchema.parse(chatModerationRequest),
  );
}

export function chatModerationRequestFromJSON(
  jsonString: string,
): SafeParseResult<ChatModerationRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ChatModerationRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ChatModerationRequest' from JSON`,
  );
}
