/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export const AgentHandoffDoneEventType = {
  AgentHandoffDone: "agent.handoff.done",
} as const;
export type AgentHandoffDoneEventType = ClosedEnum<
  typeof AgentHandoffDoneEventType
>;

export type AgentHandoffDoneEvent = {
  type?: AgentHandoffDoneEventType | undefined;
  createdAt?: Date | undefined;
  outputIndex?: number | undefined;
  id: string;
  nextAgentId: string;
  nextAgentName: string;
};

/** @internal */
export const AgentHandoffDoneEventType$inboundSchema: z.ZodNativeEnum<
  typeof AgentHandoffDoneEventType
> = z.nativeEnum(AgentHandoffDoneEventType);

/** @internal */
export const AgentHandoffDoneEventType$outboundSchema: z.ZodNativeEnum<
  typeof AgentHandoffDoneEventType
> = AgentHandoffDoneEventType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentHandoffDoneEventType$ {
  /** @deprecated use `AgentHandoffDoneEventType$inboundSchema` instead. */
  export const inboundSchema = AgentHandoffDoneEventType$inboundSchema;
  /** @deprecated use `AgentHandoffDoneEventType$outboundSchema` instead. */
  export const outboundSchema = AgentHandoffDoneEventType$outboundSchema;
}

/** @internal */
export const AgentHandoffDoneEvent$inboundSchema: z.ZodType<
  AgentHandoffDoneEvent,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: AgentHandoffDoneEventType$inboundSchema.default("agent.handoff.done"),
  created_at: z.string().datetime({ offset: true }).transform(v => new Date(v))
    .optional(),
  output_index: z.number().int().default(0),
  id: z.string(),
  next_agent_id: z.string(),
  next_agent_name: z.string(),
}).transform((v) => {
  return remap$(v, {
    "created_at": "createdAt",
    "output_index": "outputIndex",
    "next_agent_id": "nextAgentId",
    "next_agent_name": "nextAgentName",
  });
});

/** @internal */
export type AgentHandoffDoneEvent$Outbound = {
  type: string;
  created_at?: string | undefined;
  output_index: number;
  id: string;
  next_agent_id: string;
  next_agent_name: string;
};

/** @internal */
export const AgentHandoffDoneEvent$outboundSchema: z.ZodType<
  AgentHandoffDoneEvent$Outbound,
  z.ZodTypeDef,
  AgentHandoffDoneEvent
> = z.object({
  type: AgentHandoffDoneEventType$outboundSchema.default("agent.handoff.done"),
  createdAt: z.date().transform(v => v.toISOString()).optional(),
  outputIndex: z.number().int().default(0),
  id: z.string(),
  nextAgentId: z.string(),
  nextAgentName: z.string(),
}).transform((v) => {
  return remap$(v, {
    createdAt: "created_at",
    outputIndex: "output_index",
    nextAgentId: "next_agent_id",
    nextAgentName: "next_agent_name",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentHandoffDoneEvent$ {
  /** @deprecated use `AgentHandoffDoneEvent$inboundSchema` instead. */
  export const inboundSchema = AgentHandoffDoneEvent$inboundSchema;
  /** @deprecated use `AgentHandoffDoneEvent$outboundSchema` instead. */
  export const outboundSchema = AgentHandoffDoneEvent$outboundSchema;
  /** @deprecated use `AgentHandoffDoneEvent$Outbound` instead. */
  export type Outbound = AgentHandoffDoneEvent$Outbound;
}

export function agentHandoffDoneEventToJSON(
  agentHandoffDoneEvent: AgentHandoffDoneEvent,
): string {
  return JSON.stringify(
    AgentHandoffDoneEvent$outboundSchema.parse(agentHandoffDoneEvent),
  );
}

export function agentHandoffDoneEventFromJSON(
  jsonString: string,
): SafeParseResult<AgentHandoffDoneEvent, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => AgentHandoffDoneEvent$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AgentHandoffDoneEvent' from JSON`,
  );
}
