"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MistralAgents = void 0;
const betaAgentsCreate_js_1 = require("../funcs/betaAgentsCreate.js");
const betaAgentsGet_js_1 = require("../funcs/betaAgentsGet.js");
const betaAgentsList_js_1 = require("../funcs/betaAgentsList.js");
const betaAgentsUpdate_js_1 = require("../funcs/betaAgentsUpdate.js");
const betaAgentsUpdateVersion_js_1 = require("../funcs/betaAgentsUpdateVersion.js");
const sdks_js_1 = require("../lib/sdks.js");
const fp_js_1 = require("../types/fp.js");
class MistralAgents extends sdks_js_1.ClientSDK {
    /**
     * Create a agent that can be used within a conversation.
     *
     * @remarks
     * Create a new agent giving it instructions, tools, description. The agent is then available to be used as a regular assistant in a conversation or as part of an agent pool from which it can be used.
     */
    async create(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaAgentsCreate_js_1.betaAgentsCreate)(this, request, options));
    }
    /**
     * List agent entities.
     *
     * @remarks
     * Retrieve a list of agent entities sorted by creation time.
     */
    async list(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaAgentsList_js_1.betaAgentsList)(this, request, options));
    }
    /**
     * Retrieve an agent entity.
     *
     * @remarks
     * Given an agent retrieve an agent entity with its attributes.
     */
    async get(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaAgentsGet_js_1.betaAgentsGet)(this, request, options));
    }
    /**
     * Update an agent entity.
     *
     * @remarks
     * Update an agent attributes and create a new version.
     */
    async update(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaAgentsUpdate_js_1.betaAgentsUpdate)(this, request, options));
    }
    /**
     * Update an agent version.
     *
     * @remarks
     * Switch the version of an agent.
     */
    async updateVersion(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaAgentsUpdateVersion_js_1.betaAgentsUpdateVersion)(this, request, options));
    }
}
exports.MistralAgents = MistralAgents;
//# sourceMappingURL=mistralagents.js.map