import type { Tool, ToolCall } from "../types.js";
/**
 * Finds a tool by name and validates the tool call arguments against its TypeBox schema
 * @param tools Array of tool definitions
 * @param toolCall The tool call from the LLM
 * @returns The validated arguments
 * @throws Error if tool is not found or validation fails
 */
export declare function validateToolCall(tools: Tool[], toolCall: ToolCall): any;
/**
 * Validates tool call arguments against the tool's TypeBox schema
 * @param tool The tool definition with TypeBox schema
 * @param toolCall The tool call from the LLM
 * @returns The validated (and potentially coerced) arguments
 * @throws Error with formatted message if validation fails
 */
export declare function validateToolArguments(tool: Tool, toolCall: ToolCall): any;
//# sourceMappingURL=validation.d.ts.map