import { type TUnsafe } from "@sinclair/typebox";
/**
 * Creates a string enum schema compatible with Google's API and other providers
 * that don't support anyOf/const patterns.
 *
 * @example
 * const OperationSchema = StringEnum(["add", "subtract", "multiply", "divide"], {
 *   description: "The operation to perform"
 * });
 *
 * type Operation = Static<typeof OperationSchema>; // "add" | "subtract" | "multiply" | "divide"
 */
export declare function StringEnum<T extends readonly string[]>(values: T, options?: {
    description?: string;
    default?: T[number];
}): TUnsafe<T[number]>;
//# sourceMappingURL=typebox-helpers.d.ts.map