/**
 * Config — Load application configuration from ~/.ami/config/app-backend.yaml.
 *
 * Ported from config_loader pattern in Python daemon.
 */
import type { Model } from "@mariozechner/pi-ai";
export declare const AMI_DIR: string;
export declare const CONFIG_DIR: string;
export declare const CONFIG_FILE: string;
export declare const LOG_DIR: string;
export declare const PORT_FILE: string;
export interface AppConfig {
    daemon: {
        port: number;
        host: string;
    };
    cloud: {
        api_url: string;
    };
    llm: {
        model: string;
        use_proxy: boolean;
        proxy_url?: string;
    };
    storage: {
        base_path: string;
    };
    browser: {
        auto_start: boolean;
        headless: boolean;
    };
}
export declare function loadConfig(): AppConfig;
export declare function getConfig(): AppConfig;
/**
 * Build a Model object from config.
 *
 * Priority: settings.json overrides > app-backend.yaml > defaults.
 * - If llm.use_proxy=true, uses a custom Model with config model ID + proxy baseUrl
 * - Otherwise, uses pi-ai's built-in getModel() with Anthropic defaults
 */
export declare function getConfiguredModel(): Model<"anthropic-messages">;
/**
 * Resolve Anthropic API key.
 * Priority: settings.json credentials → ANTHROPIC_API_KEY env var.
 */
export declare function getAnthropicApiKey(): string | undefined;
/**
 * Resolve Anthropic base URL.
 * Priority: settings.json credentials → ANTHROPIC_BASE_URL env var.
 */
export declare function getAnthropicBaseUrl(): string | undefined;
//# sourceMappingURL=config.d.ts.map