/**
 * Browser Tools — All browser automation tools as AgentTool<TSchema>[].
 *
 * Ported from browser_toolkit.py.
 *
 * 15 tools: visit_page, click, type, enter, back, forward, scroll,
 * select, press_key, mouse_control, get_page_snapshot, get_tab_info,
 * switch_tab, new_tab, close_tab.
 *
 * Each tool:
 * 1. Gets browser session
 * 2. Executes action via ActionExecutor
 * 3. Waits for stability
 * 4. Returns snapshot + page context + tab info
 * 5. Sends screenshot SSE event
 */
import type { AgentTool } from "@mariozechner/pi-agent-core";
import type { SSEEmitter } from "../events/emitter.js";
/** All available browser tool names. */
export declare const ALL_BROWSER_TOOLS: readonly ["browser_visit_page", "browser_back", "browser_forward", "browser_scroll", "browser_click", "browser_type", "browser_enter", "browser_select", "browser_press_key", "browser_mouse_control", "browser_get_page_snapshot", "browser_get_tab_info", "browser_switch_tab", "browser_new_tab", "browser_close_tab"];
/** Default enabled tools (matches Eigent's browser_agent defaults). */
export declare const DEFAULT_BROWSER_TOOLS: readonly ["browser_visit_page", "browser_click", "browser_type", "browser_back", "browser_forward", "browser_select", "browser_switch_tab", "browser_enter", "browser_get_page_snapshot", "browser_scroll"];
/**
 * Create all browser tools for a given session.
 *
 * @param sessionId - Browser session ID (used for pool management)
 * @param emitter - Optional SSE emitter for screenshot events
 * @param enabledTools - Subset of tools to return. If undefined, uses DEFAULT_BROWSER_TOOLS.
 */
export declare function createBrowserTools(sessionId: string, emitter?: SSEEmitter, enabledTools?: readonly string[]): AgentTool<any>[];
//# sourceMappingURL=browser-tools.d.ts.map