/**
 * Event Bridge — maps pi-agent-core AgentEvent → SSE ActionData.
 *
 * Subscribes to an Agent's event stream and forwards translated events
 * to an SSEEmitter for streaming to the frontend.
 */
import type { AgentEvent } from "@mariozechner/pi-agent-core";
import { type ActionData } from "./types.js";
import type { SSEEmitter } from "./emitter.js";
/**
 * Map a single pi-agent-core AgentEvent to an SSE ActionData, or null if no mapping.
 */
export declare function mapAgentEventToSSE(event: AgentEvent, taskId: string, agentName?: string): ActionData | null;
/**
 * Bridge: subscribe to an Agent and forward events to an SSEEmitter.
 * Returns an unsubscribe function.
 *
 * Detects agent errors (stopReason === "error") and emits SSE error events
 * so the frontend is notified immediately when an API call fails.
 *
 * Also tracks accumulated text within a turn: when a tool_execution_start
 * fires after text was emitted, an agent_report(report_type="thinking")
 * is sent so the frontend ChatBox shows the agent's reasoning.
 * (Matches Python AMIAgent.astep() lines 558-564)
 */
export declare function bridgeAgentToSSE(agent: {
    subscribe: (cb: (event: AgentEvent) => void) => () => void;
}, emitter: SSEEmitter, taskId: string, agentName?: string, subtaskLabel?: string): () => void;
//# sourceMappingURL=bridge.d.ts.map