/**
 * Execution Data Collector — Extracts tool use and thinking from agent messages.
 *
 * Ported from execution_data_collector.py.
 *
 * Collects execution data from agent conversations after each subtask completes.
 * Compresses tool inputs/outputs and extracts thinking/judgment for the LearnerAgent.
 *
 * Data source: agent.state.messages returns Anthropic-format messages.
 */
import type { Agent } from "@mariozechner/pi-agent-core";
import { type AMISubtask, type TaskExecutionData } from "./schemas.js";
export declare class ExecutionDataCollector {
    private subtaskData;
    /**
     * Extract and compress execution data from a completed subtask.
     */
    collectSubtaskData(agent: Agent, subtask: AMISubtask): void;
    /**
     * Build complete TaskExecutionData from collected subtask data.
     */
    buildTaskData(taskId: string, userRequest: string, subtasks: AMISubtask[]): TaskExecutionData;
    /**
     * Serialize TaskExecutionData to snake_case dict for cloud API.
     * Matches Python's TaskExecutionData.to_dict().
     */
    static toDict(data: TaskExecutionData): Record<string, unknown>;
    private extractToolRecords;
    static compressToolInput(toolName: string, inputDict: any): string;
    static extractCurrentUrl(toolResultText: string): string;
}
//# sourceMappingURL=execution-data-collector.d.ts.map