/**
 * Budget Tracker — tracks LLM cost per task.
 *
 * Ported from the budget tracking concept in the Python daemon.
 * Uses pi-ai response.usage.cost data when available.
 */
export declare class BudgetTracker {
    private _totalCost;
    private _totalInputTokens;
    private _totalOutputTokens;
    private _callCount;
    private _budgetLimit;
    private _taskId;
    constructor(taskId: string, budgetLimit?: number);
    get totalCost(): number;
    get totalInputTokens(): number;
    get totalOutputTokens(): number;
    get callCount(): number;
    get isOverBudget(): boolean;
    /**
     * Record usage from a pi-ai response.
     * pi-ai Usage type: { input, output, cacheRead, cacheWrite, totalTokens, cost: { total, ... } }
     */
    recordUsage(usage: {
        input?: number;
        output?: number;
        totalTokens?: number;
        cost?: {
            total?: number;
        };
    }): void;
    /**
     * Get a summary of token usage.
     */
    getSummary(): {
        totalCost: number;
        totalInputTokens: number;
        totalOutputTokens: number;
        callCount: number;
        isOverBudget: boolean;
    };
    /**
     * Reset all counters.
     */
    reset(): void;
}
//# sourceMappingURL=budget.d.ts.map