/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import * as components from "../components/index.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export type AgentsApiV1AgentsUpdateRequest = {
  agentId: string;
  agentUpdateRequest: components.AgentUpdateRequest;
};

/** @internal */
export const AgentsApiV1AgentsUpdateRequest$inboundSchema: z.ZodType<
  AgentsApiV1AgentsUpdateRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  agent_id: z.string(),
  AgentUpdateRequest: components.AgentUpdateRequest$inboundSchema,
}).transform((v) => {
  return remap$(v, {
    "agent_id": "agentId",
    "AgentUpdateRequest": "agentUpdateRequest",
  });
});

/** @internal */
export type AgentsApiV1AgentsUpdateRequest$Outbound = {
  agent_id: string;
  AgentUpdateRequest: components.AgentUpdateRequest$Outbound;
};

/** @internal */
export const AgentsApiV1AgentsUpdateRequest$outboundSchema: z.ZodType<
  AgentsApiV1AgentsUpdateRequest$Outbound,
  z.ZodTypeDef,
  AgentsApiV1AgentsUpdateRequest
> = z.object({
  agentId: z.string(),
  agentUpdateRequest: components.AgentUpdateRequest$outboundSchema,
}).transform((v) => {
  return remap$(v, {
    agentId: "agent_id",
    agentUpdateRequest: "AgentUpdateRequest",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentsApiV1AgentsUpdateRequest$ {
  /** @deprecated use `AgentsApiV1AgentsUpdateRequest$inboundSchema` instead. */
  export const inboundSchema = AgentsApiV1AgentsUpdateRequest$inboundSchema;
  /** @deprecated use `AgentsApiV1AgentsUpdateRequest$outboundSchema` instead. */
  export const outboundSchema = AgentsApiV1AgentsUpdateRequest$outboundSchema;
  /** @deprecated use `AgentsApiV1AgentsUpdateRequest$Outbound` instead. */
  export type Outbound = AgentsApiV1AgentsUpdateRequest$Outbound;
}

export function agentsApiV1AgentsUpdateRequestToJSON(
  agentsApiV1AgentsUpdateRequest: AgentsApiV1AgentsUpdateRequest,
): string {
  return JSON.stringify(
    AgentsApiV1AgentsUpdateRequest$outboundSchema.parse(
      agentsApiV1AgentsUpdateRequest,
    ),
  );
}

export function agentsApiV1AgentsUpdateRequestFromJSON(
  jsonString: string,
): SafeParseResult<AgentsApiV1AgentsUpdateRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => AgentsApiV1AgentsUpdateRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AgentsApiV1AgentsUpdateRequest' from JSON`,
  );
}
