/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export type ConversationUsageInfo = {
  promptTokens?: number | undefined;
  completionTokens?: number | undefined;
  totalTokens?: number | undefined;
  connectorTokens?: number | null | undefined;
  connectors?: { [k: string]: number } | null | undefined;
};

/** @internal */
export const ConversationUsageInfo$inboundSchema: z.ZodType<
  ConversationUsageInfo,
  z.ZodTypeDef,
  unknown
> = z.object({
  prompt_tokens: z.number().int().default(0),
  completion_tokens: z.number().int().default(0),
  total_tokens: z.number().int().default(0),
  connector_tokens: z.nullable(z.number().int()).optional(),
  connectors: z.nullable(z.record(z.number().int())).optional(),
}).transform((v) => {
  return remap$(v, {
    "prompt_tokens": "promptTokens",
    "completion_tokens": "completionTokens",
    "total_tokens": "totalTokens",
    "connector_tokens": "connectorTokens",
  });
});

/** @internal */
export type ConversationUsageInfo$Outbound = {
  prompt_tokens: number;
  completion_tokens: number;
  total_tokens: number;
  connector_tokens?: number | null | undefined;
  connectors?: { [k: string]: number } | null | undefined;
};

/** @internal */
export const ConversationUsageInfo$outboundSchema: z.ZodType<
  ConversationUsageInfo$Outbound,
  z.ZodTypeDef,
  ConversationUsageInfo
> = z.object({
  promptTokens: z.number().int().default(0),
  completionTokens: z.number().int().default(0),
  totalTokens: z.number().int().default(0),
  connectorTokens: z.nullable(z.number().int()).optional(),
  connectors: z.nullable(z.record(z.number().int())).optional(),
}).transform((v) => {
  return remap$(v, {
    promptTokens: "prompt_tokens",
    completionTokens: "completion_tokens",
    totalTokens: "total_tokens",
    connectorTokens: "connector_tokens",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationUsageInfo$ {
  /** @deprecated use `ConversationUsageInfo$inboundSchema` instead. */
  export const inboundSchema = ConversationUsageInfo$inboundSchema;
  /** @deprecated use `ConversationUsageInfo$outboundSchema` instead. */
  export const outboundSchema = ConversationUsageInfo$outboundSchema;
  /** @deprecated use `ConversationUsageInfo$Outbound` instead. */
  export type Outbound = ConversationUsageInfo$Outbound;
}

export function conversationUsageInfoToJSON(
  conversationUsageInfo: ConversationUsageInfo,
): string {
  return JSON.stringify(
    ConversationUsageInfo$outboundSchema.parse(conversationUsageInfo),
  );
}

export function conversationUsageInfoFromJSON(
  jsonString: string,
): SafeParseResult<ConversationUsageInfo, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ConversationUsageInfo$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ConversationUsageInfo' from JSON`,
  );
}
