/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  CompletionTrainingParameters,
  CompletionTrainingParameters$inboundSchema,
  CompletionTrainingParameters$Outbound,
  CompletionTrainingParameters$outboundSchema,
} from "./completiontrainingparameters.js";
import {
  GithubRepositoryOut,
  GithubRepositoryOut$inboundSchema,
  GithubRepositoryOut$Outbound,
  GithubRepositoryOut$outboundSchema,
} from "./githubrepositoryout.js";
import {
  JobMetadataOut,
  JobMetadataOut$inboundSchema,
  JobMetadataOut$Outbound,
  JobMetadataOut$outboundSchema,
} from "./jobmetadataout.js";
import {
  WandbIntegrationOut,
  WandbIntegrationOut$inboundSchema,
  WandbIntegrationOut$Outbound,
  WandbIntegrationOut$outboundSchema,
} from "./wandbintegrationout.js";

/**
 * The current status of the fine-tuning job.
 */
export const Status = {
  Queued: "QUEUED",
  Started: "STARTED",
  Validating: "VALIDATING",
  Validated: "VALIDATED",
  Running: "RUNNING",
  FailedValidation: "FAILED_VALIDATION",
  Failed: "FAILED",
  Success: "SUCCESS",
  Cancelled: "CANCELLED",
  CancellationRequested: "CANCELLATION_REQUESTED",
} as const;
/**
 * The current status of the fine-tuning job.
 */
export type Status = ClosedEnum<typeof Status>;

/**
 * The object type of the fine-tuning job.
 */
export const CompletionJobOutObject = {
  Job: "job",
} as const;
/**
 * The object type of the fine-tuning job.
 */
export type CompletionJobOutObject = ClosedEnum<typeof CompletionJobOutObject>;

export type Integrations = WandbIntegrationOut;

/**
 * The type of job (`FT` for fine-tuning).
 */
export const JobType = {
  Completion: "completion",
} as const;
/**
 * The type of job (`FT` for fine-tuning).
 */
export type JobType = ClosedEnum<typeof JobType>;

export type Repositories = GithubRepositoryOut;

export type CompletionJobOut = {
  /**
   * The ID of the job.
   */
  id: string;
  autoStart: boolean;
  /**
   * The name of the model to fine-tune.
   */
  model: string;
  /**
   * The current status of the fine-tuning job.
   */
  status: Status;
  /**
   * The UNIX timestamp (in seconds) for when the fine-tuning job was created.
   */
  createdAt: number;
  /**
   * The UNIX timestamp (in seconds) for when the fine-tuning job was last modified.
   */
  modifiedAt: number;
  /**
   * A list containing the IDs of uploaded files that contain training data.
   */
  trainingFiles: Array<string>;
  /**
   * A list containing the IDs of uploaded files that contain validation data.
   */
  validationFiles?: Array<string> | null | undefined;
  /**
   * The object type of the fine-tuning job.
   */
  object?: CompletionJobOutObject | undefined;
  /**
   * The name of the fine-tuned model that is being created. The value will be `null` if the fine-tuning job is still running.
   */
  fineTunedModel?: string | null | undefined;
  /**
   * Optional text/code that adds more context for the model. When given a `prompt` and a `suffix` the model will fill what is between them. When `suffix` is not provided, the model will simply execute completion starting with `prompt`.
   */
  suffix?: string | null | undefined;
  /**
   * A list of integrations enabled for your fine-tuning job.
   */
  integrations?: Array<WandbIntegrationOut> | null | undefined;
  /**
   * Total number of tokens trained.
   */
  trainedTokens?: number | null | undefined;
  metadata?: JobMetadataOut | null | undefined;
  /**
   * The type of job (`FT` for fine-tuning).
   */
  jobType?: JobType | undefined;
  hyperparameters: CompletionTrainingParameters;
  repositories?: Array<GithubRepositoryOut> | undefined;
};

/** @internal */
export const Status$inboundSchema: z.ZodNativeEnum<typeof Status> = z
  .nativeEnum(Status);

/** @internal */
export const Status$outboundSchema: z.ZodNativeEnum<typeof Status> =
  Status$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Status$ {
  /** @deprecated use `Status$inboundSchema` instead. */
  export const inboundSchema = Status$inboundSchema;
  /** @deprecated use `Status$outboundSchema` instead. */
  export const outboundSchema = Status$outboundSchema;
}

/** @internal */
export const CompletionJobOutObject$inboundSchema: z.ZodNativeEnum<
  typeof CompletionJobOutObject
> = z.nativeEnum(CompletionJobOutObject);

/** @internal */
export const CompletionJobOutObject$outboundSchema: z.ZodNativeEnum<
  typeof CompletionJobOutObject
> = CompletionJobOutObject$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CompletionJobOutObject$ {
  /** @deprecated use `CompletionJobOutObject$inboundSchema` instead. */
  export const inboundSchema = CompletionJobOutObject$inboundSchema;
  /** @deprecated use `CompletionJobOutObject$outboundSchema` instead. */
  export const outboundSchema = CompletionJobOutObject$outboundSchema;
}

/** @internal */
export const Integrations$inboundSchema: z.ZodType<
  Integrations,
  z.ZodTypeDef,
  unknown
> = WandbIntegrationOut$inboundSchema;

/** @internal */
export type Integrations$Outbound = WandbIntegrationOut$Outbound;

/** @internal */
export const Integrations$outboundSchema: z.ZodType<
  Integrations$Outbound,
  z.ZodTypeDef,
  Integrations
> = WandbIntegrationOut$outboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Integrations$ {
  /** @deprecated use `Integrations$inboundSchema` instead. */
  export const inboundSchema = Integrations$inboundSchema;
  /** @deprecated use `Integrations$outboundSchema` instead. */
  export const outboundSchema = Integrations$outboundSchema;
  /** @deprecated use `Integrations$Outbound` instead. */
  export type Outbound = Integrations$Outbound;
}

export function integrationsToJSON(integrations: Integrations): string {
  return JSON.stringify(Integrations$outboundSchema.parse(integrations));
}

export function integrationsFromJSON(
  jsonString: string,
): SafeParseResult<Integrations, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => Integrations$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'Integrations' from JSON`,
  );
}

/** @internal */
export const JobType$inboundSchema: z.ZodNativeEnum<typeof JobType> = z
  .nativeEnum(JobType);

/** @internal */
export const JobType$outboundSchema: z.ZodNativeEnum<typeof JobType> =
  JobType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace JobType$ {
  /** @deprecated use `JobType$inboundSchema` instead. */
  export const inboundSchema = JobType$inboundSchema;
  /** @deprecated use `JobType$outboundSchema` instead. */
  export const outboundSchema = JobType$outboundSchema;
}

/** @internal */
export const Repositories$inboundSchema: z.ZodType<
  Repositories,
  z.ZodTypeDef,
  unknown
> = GithubRepositoryOut$inboundSchema;

/** @internal */
export type Repositories$Outbound = GithubRepositoryOut$Outbound;

/** @internal */
export const Repositories$outboundSchema: z.ZodType<
  Repositories$Outbound,
  z.ZodTypeDef,
  Repositories
> = GithubRepositoryOut$outboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Repositories$ {
  /** @deprecated use `Repositories$inboundSchema` instead. */
  export const inboundSchema = Repositories$inboundSchema;
  /** @deprecated use `Repositories$outboundSchema` instead. */
  export const outboundSchema = Repositories$outboundSchema;
  /** @deprecated use `Repositories$Outbound` instead. */
  export type Outbound = Repositories$Outbound;
}

export function repositoriesToJSON(repositories: Repositories): string {
  return JSON.stringify(Repositories$outboundSchema.parse(repositories));
}

export function repositoriesFromJSON(
  jsonString: string,
): SafeParseResult<Repositories, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => Repositories$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'Repositories' from JSON`,
  );
}

/** @internal */
export const CompletionJobOut$inboundSchema: z.ZodType<
  CompletionJobOut,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  auto_start: z.boolean(),
  model: z.string(),
  status: Status$inboundSchema,
  created_at: z.number().int(),
  modified_at: z.number().int(),
  training_files: z.array(z.string()),
  validation_files: z.nullable(z.array(z.string())).optional(),
  object: CompletionJobOutObject$inboundSchema.default("job"),
  fine_tuned_model: z.nullable(z.string()).optional(),
  suffix: z.nullable(z.string()).optional(),
  integrations: z.nullable(z.array(WandbIntegrationOut$inboundSchema))
    .optional(),
  trained_tokens: z.nullable(z.number().int()).optional(),
  metadata: z.nullable(JobMetadataOut$inboundSchema).optional(),
  job_type: JobType$inboundSchema.default("completion"),
  hyperparameters: CompletionTrainingParameters$inboundSchema,
  repositories: z.array(GithubRepositoryOut$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "auto_start": "autoStart",
    "created_at": "createdAt",
    "modified_at": "modifiedAt",
    "training_files": "trainingFiles",
    "validation_files": "validationFiles",
    "fine_tuned_model": "fineTunedModel",
    "trained_tokens": "trainedTokens",
    "job_type": "jobType",
  });
});

/** @internal */
export type CompletionJobOut$Outbound = {
  id: string;
  auto_start: boolean;
  model: string;
  status: string;
  created_at: number;
  modified_at: number;
  training_files: Array<string>;
  validation_files?: Array<string> | null | undefined;
  object: string;
  fine_tuned_model?: string | null | undefined;
  suffix?: string | null | undefined;
  integrations?: Array<WandbIntegrationOut$Outbound> | null | undefined;
  trained_tokens?: number | null | undefined;
  metadata?: JobMetadataOut$Outbound | null | undefined;
  job_type: string;
  hyperparameters: CompletionTrainingParameters$Outbound;
  repositories?: Array<GithubRepositoryOut$Outbound> | undefined;
};

/** @internal */
export const CompletionJobOut$outboundSchema: z.ZodType<
  CompletionJobOut$Outbound,
  z.ZodTypeDef,
  CompletionJobOut
> = z.object({
  id: z.string(),
  autoStart: z.boolean(),
  model: z.string(),
  status: Status$outboundSchema,
  createdAt: z.number().int(),
  modifiedAt: z.number().int(),
  trainingFiles: z.array(z.string()),
  validationFiles: z.nullable(z.array(z.string())).optional(),
  object: CompletionJobOutObject$outboundSchema.default("job"),
  fineTunedModel: z.nullable(z.string()).optional(),
  suffix: z.nullable(z.string()).optional(),
  integrations: z.nullable(z.array(WandbIntegrationOut$outboundSchema))
    .optional(),
  trainedTokens: z.nullable(z.number().int()).optional(),
  metadata: z.nullable(JobMetadataOut$outboundSchema).optional(),
  jobType: JobType$outboundSchema.default("completion"),
  hyperparameters: CompletionTrainingParameters$outboundSchema,
  repositories: z.array(GithubRepositoryOut$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    autoStart: "auto_start",
    createdAt: "created_at",
    modifiedAt: "modified_at",
    trainingFiles: "training_files",
    validationFiles: "validation_files",
    fineTunedModel: "fine_tuned_model",
    trainedTokens: "trained_tokens",
    jobType: "job_type",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CompletionJobOut$ {
  /** @deprecated use `CompletionJobOut$inboundSchema` instead. */
  export const inboundSchema = CompletionJobOut$inboundSchema;
  /** @deprecated use `CompletionJobOut$outboundSchema` instead. */
  export const outboundSchema = CompletionJobOut$outboundSchema;
  /** @deprecated use `CompletionJobOut$Outbound` instead. */
  export type Outbound = CompletionJobOut$Outbound;
}

export function completionJobOutToJSON(
  completionJobOut: CompletionJobOut,
): string {
  return JSON.stringify(
    CompletionJobOut$outboundSchema.parse(completionJobOut),
  );
}

export function completionJobOutFromJSON(
  jsonString: string,
): SafeParseResult<CompletionJobOut, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => CompletionJobOut$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'CompletionJobOut' from JSON`,
  );
}
