/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  FTClassifierLossFunction,
  FTClassifierLossFunction$inboundSchema,
  FTClassifierLossFunction$outboundSchema,
} from "./ftclassifierlossfunction.js";

export type ClassifierTargetOut = {
  name: string;
  labels: Array<string>;
  weight: number;
  lossFunction: FTClassifierLossFunction;
};

/** @internal */
export const ClassifierTargetOut$inboundSchema: z.ZodType<
  ClassifierTargetOut,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string(),
  labels: z.array(z.string()),
  weight: z.number(),
  loss_function: FTClassifierLossFunction$inboundSchema,
}).transform((v) => {
  return remap$(v, {
    "loss_function": "lossFunction",
  });
});

/** @internal */
export type ClassifierTargetOut$Outbound = {
  name: string;
  labels: Array<string>;
  weight: number;
  loss_function: string;
};

/** @internal */
export const ClassifierTargetOut$outboundSchema: z.ZodType<
  ClassifierTargetOut$Outbound,
  z.ZodTypeDef,
  ClassifierTargetOut
> = z.object({
  name: z.string(),
  labels: z.array(z.string()),
  weight: z.number(),
  lossFunction: FTClassifierLossFunction$outboundSchema,
}).transform((v) => {
  return remap$(v, {
    lossFunction: "loss_function",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ClassifierTargetOut$ {
  /** @deprecated use `ClassifierTargetOut$inboundSchema` instead. */
  export const inboundSchema = ClassifierTargetOut$inboundSchema;
  /** @deprecated use `ClassifierTargetOut$outboundSchema` instead. */
  export const outboundSchema = ClassifierTargetOut$outboundSchema;
  /** @deprecated use `ClassifierTargetOut$Outbound` instead. */
  export type Outbound = ClassifierTargetOut$Outbound;
}

export function classifierTargetOutToJSON(
  classifierTargetOut: ClassifierTargetOut,
): string {
  return JSON.stringify(
    ClassifierTargetOut$outboundSchema.parse(classifierTargetOut),
  );
}

export function classifierTargetOutFromJSON(
  jsonString: string,
): SafeParseResult<ClassifierTargetOut, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ClassifierTargetOut$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ClassifierTargetOut' from JSON`,
  );
}
