/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  ClassifierTargetOut,
  ClassifierTargetOut$inboundSchema,
  ClassifierTargetOut$Outbound,
  ClassifierTargetOut$outboundSchema,
} from "./classifiertargetout.js";
import {
  FTModelCapabilitiesOut,
  FTModelCapabilitiesOut$inboundSchema,
  FTModelCapabilitiesOut$Outbound,
  FTModelCapabilitiesOut$outboundSchema,
} from "./ftmodelcapabilitiesout.js";

export const ClassifierFTModelOutObject = {
  Model: "model",
} as const;
export type ClassifierFTModelOutObject = ClosedEnum<
  typeof ClassifierFTModelOutObject
>;

export const ClassifierFTModelOutModelType = {
  Classifier: "classifier",
} as const;
export type ClassifierFTModelOutModelType = ClosedEnum<
  typeof ClassifierFTModelOutModelType
>;

export type ClassifierFTModelOut = {
  id: string;
  object?: ClassifierFTModelOutObject | undefined;
  created: number;
  ownedBy: string;
  workspaceId: string;
  root: string;
  rootVersion: string;
  archived: boolean;
  name?: string | null | undefined;
  description?: string | null | undefined;
  capabilities: FTModelCapabilitiesOut;
  maxContextLength?: number | undefined;
  aliases?: Array<string> | undefined;
  job: string;
  classifierTargets: Array<ClassifierTargetOut>;
  modelType?: ClassifierFTModelOutModelType | undefined;
};

/** @internal */
export const ClassifierFTModelOutObject$inboundSchema: z.ZodNativeEnum<
  typeof ClassifierFTModelOutObject
> = z.nativeEnum(ClassifierFTModelOutObject);

/** @internal */
export const ClassifierFTModelOutObject$outboundSchema: z.ZodNativeEnum<
  typeof ClassifierFTModelOutObject
> = ClassifierFTModelOutObject$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ClassifierFTModelOutObject$ {
  /** @deprecated use `ClassifierFTModelOutObject$inboundSchema` instead. */
  export const inboundSchema = ClassifierFTModelOutObject$inboundSchema;
  /** @deprecated use `ClassifierFTModelOutObject$outboundSchema` instead. */
  export const outboundSchema = ClassifierFTModelOutObject$outboundSchema;
}

/** @internal */
export const ClassifierFTModelOutModelType$inboundSchema: z.ZodNativeEnum<
  typeof ClassifierFTModelOutModelType
> = z.nativeEnum(ClassifierFTModelOutModelType);

/** @internal */
export const ClassifierFTModelOutModelType$outboundSchema: z.ZodNativeEnum<
  typeof ClassifierFTModelOutModelType
> = ClassifierFTModelOutModelType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ClassifierFTModelOutModelType$ {
  /** @deprecated use `ClassifierFTModelOutModelType$inboundSchema` instead. */
  export const inboundSchema = ClassifierFTModelOutModelType$inboundSchema;
  /** @deprecated use `ClassifierFTModelOutModelType$outboundSchema` instead. */
  export const outboundSchema = ClassifierFTModelOutModelType$outboundSchema;
}

/** @internal */
export const ClassifierFTModelOut$inboundSchema: z.ZodType<
  ClassifierFTModelOut,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  object: ClassifierFTModelOutObject$inboundSchema.default("model"),
  created: z.number().int(),
  owned_by: z.string(),
  workspace_id: z.string(),
  root: z.string(),
  root_version: z.string(),
  archived: z.boolean(),
  name: z.nullable(z.string()).optional(),
  description: z.nullable(z.string()).optional(),
  capabilities: FTModelCapabilitiesOut$inboundSchema,
  max_context_length: z.number().int().default(32768),
  aliases: z.array(z.string()).optional(),
  job: z.string(),
  classifier_targets: z.array(ClassifierTargetOut$inboundSchema),
  model_type: ClassifierFTModelOutModelType$inboundSchema.default("classifier"),
}).transform((v) => {
  return remap$(v, {
    "owned_by": "ownedBy",
    "workspace_id": "workspaceId",
    "root_version": "rootVersion",
    "max_context_length": "maxContextLength",
    "classifier_targets": "classifierTargets",
    "model_type": "modelType",
  });
});

/** @internal */
export type ClassifierFTModelOut$Outbound = {
  id: string;
  object: string;
  created: number;
  owned_by: string;
  workspace_id: string;
  root: string;
  root_version: string;
  archived: boolean;
  name?: string | null | undefined;
  description?: string | null | undefined;
  capabilities: FTModelCapabilitiesOut$Outbound;
  max_context_length: number;
  aliases?: Array<string> | undefined;
  job: string;
  classifier_targets: Array<ClassifierTargetOut$Outbound>;
  model_type: string;
};

/** @internal */
export const ClassifierFTModelOut$outboundSchema: z.ZodType<
  ClassifierFTModelOut$Outbound,
  z.ZodTypeDef,
  ClassifierFTModelOut
> = z.object({
  id: z.string(),
  object: ClassifierFTModelOutObject$outboundSchema.default("model"),
  created: z.number().int(),
  ownedBy: z.string(),
  workspaceId: z.string(),
  root: z.string(),
  rootVersion: z.string(),
  archived: z.boolean(),
  name: z.nullable(z.string()).optional(),
  description: z.nullable(z.string()).optional(),
  capabilities: FTModelCapabilitiesOut$outboundSchema,
  maxContextLength: z.number().int().default(32768),
  aliases: z.array(z.string()).optional(),
  job: z.string(),
  classifierTargets: z.array(ClassifierTargetOut$outboundSchema),
  modelType: ClassifierFTModelOutModelType$outboundSchema.default("classifier"),
}).transform((v) => {
  return remap$(v, {
    ownedBy: "owned_by",
    workspaceId: "workspace_id",
    rootVersion: "root_version",
    maxContextLength: "max_context_length",
    classifierTargets: "classifier_targets",
    modelType: "model_type",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ClassifierFTModelOut$ {
  /** @deprecated use `ClassifierFTModelOut$inboundSchema` instead. */
  export const inboundSchema = ClassifierFTModelOut$inboundSchema;
  /** @deprecated use `ClassifierFTModelOut$outboundSchema` instead. */
  export const outboundSchema = ClassifierFTModelOut$outboundSchema;
  /** @deprecated use `ClassifierFTModelOut$Outbound` instead. */
  export type Outbound = ClassifierFTModelOut$Outbound;
}

export function classifierFTModelOutToJSON(
  classifierFTModelOut: ClassifierFTModelOut,
): string {
  return JSON.stringify(
    ClassifierFTModelOut$outboundSchema.parse(classifierFTModelOut),
  );
}

export function classifierFTModelOutFromJSON(
  jsonString: string,
): SafeParseResult<ClassifierFTModelOut, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ClassifierFTModelOut$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ClassifierFTModelOut' from JSON`,
  );
}
