"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Libraries = void 0;
const betaLibrariesCreate_js_1 = require("../funcs/betaLibrariesCreate.js");
const betaLibrariesDelete_js_1 = require("../funcs/betaLibrariesDelete.js");
const betaLibrariesGet_js_1 = require("../funcs/betaLibrariesGet.js");
const betaLibrariesList_js_1 = require("../funcs/betaLibrariesList.js");
const betaLibrariesUpdate_js_1 = require("../funcs/betaLibrariesUpdate.js");
const sdks_js_1 = require("../lib/sdks.js");
const fp_js_1 = require("../types/fp.js");
const accesses_js_1 = require("./accesses.js");
const documents_js_1 = require("./documents.js");
class Libraries extends sdks_js_1.ClientSDK {
    get documents() {
        return (this._documents ?? (this._documents = new documents_js_1.Documents(this._options)));
    }
    get accesses() {
        return (this._accesses ?? (this._accesses = new accesses_js_1.Accesses(this._options)));
    }
    /**
     * List all libraries you have access to.
     *
     * @remarks
     * List all libraries that you have created or have been shared with you.
     */
    async list(options) {
        return (0, fp_js_1.unwrapAsync)((0, betaLibrariesList_js_1.betaLibrariesList)(this, options));
    }
    /**
     * Create a new Library.
     *
     * @remarks
     * Create a new Library, you will be marked as the owner and only you will have the possibility to share it with others. When first created this will only be accessible by you.
     */
    async create(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaLibrariesCreate_js_1.betaLibrariesCreate)(this, request, options));
    }
    /**
     * Detailed information about a specific Library.
     *
     * @remarks
     * Given a library id, details information about that Library.
     */
    async get(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaLibrariesGet_js_1.betaLibrariesGet)(this, request, options));
    }
    /**
     * Delete a library and all of it's document.
     *
     * @remarks
     * Given a library id, deletes it together with all documents that have been uploaded to that library.
     */
    async delete(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaLibrariesDelete_js_1.betaLibrariesDelete)(this, request, options));
    }
    /**
     * Update a library.
     *
     * @remarks
     * Given a library id, you can update the name and description.
     */
    async update(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaLibrariesUpdate_js_1.betaLibrariesUpdate)(this, request, options));
    }
}
exports.Libraries = Libraries;
//# sourceMappingURL=libraries.js.map