"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Files = void 0;
const filesDelete_js_1 = require("../funcs/filesDelete.js");
const filesDownload_js_1 = require("../funcs/filesDownload.js");
const filesGetSignedUrl_js_1 = require("../funcs/filesGetSignedUrl.js");
const filesList_js_1 = require("../funcs/filesList.js");
const filesRetrieve_js_1 = require("../funcs/filesRetrieve.js");
const filesUpload_js_1 = require("../funcs/filesUpload.js");
const sdks_js_1 = require("../lib/sdks.js");
const fp_js_1 = require("../types/fp.js");
class Files extends sdks_js_1.ClientSDK {
    /**
     * Upload File
     *
     * @remarks
     * Upload a file that can be used across various endpoints.
     *
     * The size of individual files can be a maximum of 512 MB. The Fine-tuning API only supports .jsonl files.
     *
     * Please contact us if you need to increase these storage limits.
     */
    async upload(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, filesUpload_js_1.filesUpload)(this, request, options));
    }
    /**
     * List Files
     *
     * @remarks
     * Returns a list of files that belong to the user's organization.
     */
    async list(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, filesList_js_1.filesList)(this, request, options));
    }
    /**
     * Retrieve File
     *
     * @remarks
     * Returns information about a specific file.
     */
    async retrieve(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, filesRetrieve_js_1.filesRetrieve)(this, request, options));
    }
    /**
     * Delete File
     *
     * @remarks
     * Delete a file.
     */
    async delete(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, filesDelete_js_1.filesDelete)(this, request, options));
    }
    /**
     * Download File
     *
     * @remarks
     * Download a file
     */
    async download(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, filesDownload_js_1.filesDownload)(this, request, options));
    }
    /**
     * Get Signed Url
     */
    async getSignedUrl(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, filesGetSignedUrl_js_1.filesGetSignedUrl)(this, request, options));
    }
}
exports.Files = Files;
//# sourceMappingURL=files.js.map