/**
 * Terminal Tools — Shell command execution with safety controls.
 *
 * Ported from terminal_toolkit.py.
 *
 * Leverages the same spawn pattern as pi-coding-agent's bash tool
 * but adds AMI-specific safety features (dangerous command blocking,
 * output size limits, SSE terminal events).
 */
import type { AgentTool } from "@mariozechner/pi-agent-core";
import type { SSEEmitter } from "../events/emitter.js";
export declare function createTerminalTools(opts: {
    workingDir: string;
    taskId: string;
    emitter?: SSEEmitter;
    safeMode?: boolean;
}): AgentTool<any>[];
//# sourceMappingURL=terminal-tools.d.ts.map