/**
 * MCP Tools — Gmail, Google Drive, and Notion via MCP (Model Context Protocol).
 *
 * Ported from gmail_mcp_toolkit.py, notion_mcp_toolkit.py, gdrive_mcp_toolkit.py.
 *
 * MCP servers communicate over stdin/stdout (JSON-RPC 2.0).
 * Each server provides dynamically-discovered tools.
 */
import type { AgentTool } from "@mariozechner/pi-agent-core";
interface MCPToolDefinition {
    name: string;
    description?: string;
    inputSchema?: Record<string, unknown>;
}
export declare class MCPClient {
    private command;
    private args;
    private env?;
    private process?;
    private nextId;
    private pendingRequests;
    private buffer;
    private connected;
    constructor(command: string, args: string[], env?: Record<string, string> | undefined);
    connect(): Promise<void>;
    disconnect(): Promise<void>;
    listTools(): Promise<MCPToolDefinition[]>;
    callTool(name: string, args: Record<string, unknown>): Promise<string>;
    private sendRequest;
    private sendNotification;
    private processBuffer;
}
export declare function createGmailTools(credentialsPath?: string): Promise<{
    client: MCPClient;
    tools: AgentTool[];
}>;
export declare function createGDriveTools(): Promise<{
    client: MCPClient;
    tools: AgentTool<any>[];
}>;
export declare function createNotionTools(): Promise<{
    client: MCPClient;
    tools: AgentTool<any>[];
}>;
export {};
//# sourceMappingURL=mcp-tools.d.ts.map