/**
 * Task State Persistence — read/write task-state.json for resume support.
 *
 * Each task gets a snapshot at ~/.ami/workspace/{taskId}/task-state.json.
 * The snapshot contains the full subtask plan with states/results so a
 * restarted daemon can resume where it left off.
 */
import type { TaskStateSnapshot, SubtaskSnapshot, AMISubtask } from "../agent/schemas.js";
export declare function subtaskToSnapshot(st: AMISubtask): SubtaskSnapshot;
export declare function buildSnapshot(taskId: string, userRequest: string, subtasks: AMISubtask[], status: TaskStateSnapshot["status"], memoryPlan?: Record<string, unknown>, createdAt?: string): TaskStateSnapshot;
export declare function saveTaskState(taskId: string, snapshot: TaskStateSnapshot): void;
export declare function loadTaskState(taskId: string): TaskStateSnapshot | null;
/**
 * Scan all workspace subdirectories and return tasks whose status is NOT "completed",
 * sorted by updatedAt descending (most recent first).
 */
export declare function listResumableTasks(): TaskStateSnapshot[];
/**
 * Incrementally update a single subtask's state in the persisted snapshot.
 * Reads → patches → writes. Fire-and-forget safe (errors are logged, not thrown).
 */
export declare function updateSubtaskState(taskId: string, subtaskId: string, state: string, result?: string, error?: string): void;
/**
 * Update only the top-level status field of a persisted snapshot.
 */
export declare function updateTaskStatus(taskId: string, status: TaskStateSnapshot["status"]): void;
//# sourceMappingURL=task-state-persistence.d.ts.map