/**
 * TaskRegistry — manages all active and completed tasks.
 */
import { TaskState } from "./task-state.js";
export declare class TaskRegistry {
    private _tasks;
    create(taskId: string, task: string): TaskState;
    get(taskId: string): TaskState | undefined;
    getOrThrow(taskId: string): TaskState;
    list(): TaskState[];
    delete(taskId: string): boolean;
    get size(): number;
    /** Clean up old completed/failed tasks older than maxAgeMs. */
    cleanup(maxAgeMs?: number): number;
    /** Get summary stats. */
    stats(): {
        total: number;
        running: number;
        completed: number;
        failed: number;
    };
}
/** Global singleton registry. */
export declare const taskRegistry: TaskRegistry;
//# sourceMappingURL=task-registry.d.ts.map