/**
 * Storage Manager — Local file storage for recordings and snapshots.
 *
 * Ported from storage_manager.py.
 *
 * Directory structure:
 *   ~/.ami/users/{userId}/recordings/{sessionId}/
 *     recording.json    (metadata + operations)
 *     snapshots/
 *       {urlHash}.json  (page snapshots)
 */
export interface RecordingMetadata {
    session_id: string;
    created_at: string;
    ended_at?: string;
    updated_at?: string;
    task_metadata?: {
        name?: string;
        description?: string;
        user_query?: string;
    };
    operations: Record<string, unknown>[];
}
export interface RecordingListItem {
    session_id: string;
    task_metadata?: Record<string, unknown>;
    created_at?: string;
    action_count: number;
    snapshot_count: number;
}
export declare class StorageManager {
    private basePath;
    constructor(basePath?: string);
    private sanitizeId;
    private userPath;
    private recordingPath;
    private recordingFile;
    private snapshotsDir;
    saveRecording(userId: string, sessionId: string, data: Record<string, unknown>, updateTimestamp?: boolean): void;
    saveSnapshot(userId: string, sessionId: string, urlHash: string, snapshotData: Record<string, unknown>): void;
    getRecording(userId: string, sessionId: string): Record<string, unknown> | null;
    listRecordings(userId: string): RecordingListItem[];
    deleteRecording(userId: string, sessionId: string): boolean;
    getRecordingDetail(userId: string, sessionId: string): Record<string, unknown> | null;
    updateRecordingMetadata(userId: string, sessionId: string, updates: {
        name?: string;
        task_description?: string;
        user_query?: string;
    }): boolean;
}
export declare function getStorageManager(): StorageManager;
//# sourceMappingURL=storage-manager.d.ts.map