/**
 * Session Manager — JSONL-based conversation persistence.
 *
 * Ported from session_manager.py.
 *
 * - Each session is a JSONL file in ~/.ami/sessions/
 * - Sessions timeout after 30 minutes of inactivity
 * - New sessions carry context (last 5 messages) from previous session
 * - Cursor-based cross-session history traversal
 */
export interface SessionMessage {
    type: "message";
    id: string;
    role: string;
    content: string;
    timestamp: string;
    attachments?: Record<string, unknown>[];
    metadata?: Record<string, unknown>;
    is_context?: boolean;
    from_session?: string;
}
interface SessionInfo {
    created_at: string;
    updated_at: string;
    message_count: number;
    previous_session_id: string | null;
}
export declare class SessionManager {
    readonly basePath: string;
    private indexPath;
    private indexCache;
    constructor(basePath?: string);
    private loadIndex;
    private saveIndex;
    isSessionExpired(): boolean;
    private createNewSession;
    private carryContextFromPrevious;
    getActiveSession(): string;
    forceNewSession(): string;
    getCurrentSessionId(): string | null;
    appendMessage(role: string, content: string, messageId?: string, attachments?: Record<string, unknown>[], metadata?: Record<string, unknown>): string;
    getMessages(sessionId?: string, limit?: number): SessionMessage[];
    getSessionInfo(sessionId?: string): SessionInfo | null;
    listSessions(limit?: number): Array<SessionInfo & {
        session_id: string;
    }>;
    touchSession(): void;
    getHistoryMessages(beforeTimestamp: string, limit?: number): {
        messages: SessionMessage[];
        has_more: boolean;
        oldest_timestamp: string | null;
    };
    private readSessionMessages;
    private getPreviousSessionId;
}
export declare function getSessionManager(): SessionManager;
export {};
//# sourceMappingURL=session-manager.d.ts.map