/**
 * Task Decomposition Prompts — fine-grained decomposition and worker descriptions.
 *
 * Ported from ami_task_planner.py FINE_GRAINED_DECOMPOSE_PROMPT.
 */
// ===== Fine-grained decomposition prompt =====
export const FINE_GRAINED_DECOMPOSE_PROMPT = `\
You are a task decomposer. Convert a user's task into atomic subtasks for specialized agents.

**HOW TO WORK:**
- If an EXECUTION PLAN is provided below: this plan comes from the user's past successful workflows stored in Memory. It represents a proven execution path. Convert each plan step into subtasks, preserving the plan's structure and order. Assign the right agent type and dependencies. Add a final deliverable step if missing.
- IMPORTANT: Preserve specific operation details from the EXECUTION PLAN steps (e.g., scroll to load, specific fields to extract, exact click targets). Do NOT summarize away actionable details — they are critical for correct execution.
- If no EXECUTION PLAN is provided: decompose the task from scratch using your own knowledge.

**SUBTASK RULES:**

1. **Self-Contained**: Each subtask must include all context needed to execute it independently — specific URLs, search keywords, output format. Never use relative references like "the previous result".

2. **Clear Deliverables**: Each subtask must specify what it produces.
   - Good: "Extract top 10 products (name, price, rating, URL), save to products.md"
   - Bad: "Research products"

3. **Atomic**: Each subtask ≈ 1-2 tool calls.
   - Browser: one navigation or one data extraction
   - Document: one file operation
   - Code: one command execution

4. **Dependencies**: Only add depends_on when there is real data dependency. Independent tasks should NOT have depends_on (allows parallel execution).

5. **Final Deliverable**: The last task should produce a user-friendly output.
   - Prefer: HTML, Excel (.xlsx), CSV, Word (.docx), PowerPoint (.pptx)
   - Markdown (.md) is for intermediate notes only, NEVER as final deliverable
   - Simple questions need only a text reply, no file

**LANGUAGE POLICY**: Write subtask content in the SAME language as the user's task.

**AVAILABLE WORKERS:**
{workers_info}

**OUTPUT FORMAT (XML):**
<tasks>
<task id="1" type="browser">Visit producthunt.com and navigate to the weekly leaderboard page</task>
<task id="2" type="browser" depends_on="1">Extract the top 10 products (name, tagline, votes, profile URL). Save to products.md</task>
<task id="3" type="document" depends_on="2">Read products.md and generate an HTML report with product cards</task>
</tasks>

Each <task> element:
- "id": Sequential number (1, 2, 3...)
- "type": browser, document, code, or multi_modal
- "depends_on" (optional): Comma-separated task IDs this task needs data from

**TASK TO DECOMPOSE:**
{task}
{memory_context}

Now decompose into atomic subtasks:`;
// ===== Coarse decomposition prompt (legacy fallback) =====
export const COARSE_DECOMPOSE_PROMPT = `\
Split the task by work type. Keep related operations of the same type together.

Types:
- browser: Web browsing, research, online operations
- document: Writing reports, creating files
- code: Writing or modifying code, debugging programs, git operations

**CRITICAL Language Policy**:
- The subtask "content" field MUST be in the SAME language as the user's task.

Output JSON:
{{
    "subtasks": [
        {{"id": "1", "type": "browser", "content": "...", "depends_on": []}},
        {{"id": "2", "type": "document", "content": "...", "depends_on": ["1"]}}
    ]
}}

Task: {task}`;
// ===== Default worker descriptions =====
export const DEFAULT_WORKER_DESCRIPTIONS = {
    browser: "Browser Agent: Can search the web, visit URLs, click elements, " +
        "type text, extract page content, and take notes. Use for web research " +
        "and online operations.",
    document: "Document Agent: Can read and write files (Markdown, HTML, JSON, YAML, " +
        "Word, PDF, PowerPoint, Excel, CSV). Use for creating reports, documents, " +
        "and data files. Also capable of data analysis, filtering, comparison, " +
        "and summarization — use this agent (NOT code) for tasks like " +
        "'read JSON and filter by criteria' or 'analyze data and generate report'.",
    code: "Developer Agent: Can write code, debug programs, and use development tools " +
        "(git, npm, compilers, etc.). Use ONLY for software engineering tasks: " +
        "building applications, writing scripts that must be reused, fixing bugs, " +
        "managing repositories. Do NOT use for data analysis, filtering, or report " +
        "generation — those are document agent tasks.",
    multi_modal: "Multi-Modal Agent: Can process images, audio, and video. " +
        "Use for media analysis and generation tasks.",
};
// ===== Replan instruction (injected into subtask prompts) =====
export const REPLAN_INSTRUCTION = `\
## Task Splitting

When your task involves processing many items (>5), you should split the remaining work.
Before splitting, **save all data you have collected so far to a file**.

### How to Split (MUST follow this 2-step process)

**Step 1: Review** — Call \`replan_review_context()\` to see:
- What previous tasks have accomplished
- What files are available in the workspace
- What tasks are still pending

**Step 2: Split** — Call \`replan_split_and_handoff(summary, tasks)\`:
- summary: describe what you have done so far
- tasks: JSON array of follow-up tasks

### Rules for follow-up tasks

1. **Self-Contained**: Each task must include ALL context needed to execute it independently — specific URLs, search keywords, output file name, data format. The agent executing the task has NO knowledge of your current task or what you have done. Never use references like "the previous result", "continue where I left off", or "remaining items".
   - Good: "Visit <url>, extract <specific fields>, save to <filename> as <format>"
   - Bad: "Continue extracting the next batch"

2. **Clear Deliverables**: Each task must specify what it produces and in what format. Do NOT use vague verbs like "research" or "look into" without defining the output.
   - Good: "Extract name, price, and rating, append to results.json"
   - Bad: "Research more items"

3. **Atomic**: Each task should be a small, focused unit of work (1-2 tool calls). Browser: one navigation or one data extraction. Document: one file operation.

4. **Parallel by Default**: Tasks that don't depend on each other's output MUST NOT have dependencies. When processing multiple items, create one task per item or small batch — they can all run in parallel.

5. **Strategic Grouping**: Sequential actions of the same type that MUST happen in order should be grouped into one task.

6. **Preserve the Full Goal**: Your split must cover ALL remaining work.`;
// ===== Decompose prompt system message =====
export const DECOMPOSE_SYSTEM_MESSAGE = "You are a task decomposition expert. Split tasks by work type (browser, document, code).";
//# sourceMappingURL=task-decomposition.js.map