/**
 * Task Decomposition Prompts — fine-grained decomposition and worker descriptions.
 *
 * Ported from ami_task_planner.py FINE_GRAINED_DECOMPOSE_PROMPT.
 */
export declare const FINE_GRAINED_DECOMPOSE_PROMPT = "You are a task decomposer. Convert a user's task into atomic subtasks for specialized agents.\n\n**HOW TO WORK:**\n- If an EXECUTION PLAN is provided below: this plan comes from the user's past successful workflows stored in Memory. It represents a proven execution path. Convert each plan step into subtasks, preserving the plan's structure and order. Assign the right agent type and dependencies. Add a final deliverable step if missing.\n- IMPORTANT: Preserve specific operation details from the EXECUTION PLAN steps (e.g., scroll to load, specific fields to extract, exact click targets). Do NOT summarize away actionable details \u2014 they are critical for correct execution.\n- If no EXECUTION PLAN is provided: decompose the task from scratch using your own knowledge.\n\n**SUBTASK RULES:**\n\n1. **Self-Contained**: Each subtask must include all context needed to execute it independently \u2014 specific URLs, search keywords, output format. Never use relative references like \"the previous result\".\n\n2. **Clear Deliverables**: Each subtask must specify what it produces.\n   - Good: \"Extract top 10 products (name, price, rating, URL), save to products.md\"\n   - Bad: \"Research products\"\n\n3. **Atomic**: Each subtask \u2248 1-2 tool calls.\n   - Browser: one navigation or one data extraction\n   - Document: one file operation\n   - Code: one command execution\n\n4. **Dependencies**: Only add depends_on when there is real data dependency. Independent tasks should NOT have depends_on (allows parallel execution).\n\n5. **Final Deliverable**: The last task should produce a user-friendly output.\n   - Prefer: HTML, Excel (.xlsx), CSV, Word (.docx), PowerPoint (.pptx)\n   - Markdown (.md) is for intermediate notes only, NEVER as final deliverable\n   - Simple questions need only a text reply, no file\n\n**LANGUAGE POLICY**: Write subtask content in the SAME language as the user's task.\n\n**AVAILABLE WORKERS:**\n{workers_info}\n\n**OUTPUT FORMAT (XML):**\n<tasks>\n<task id=\"1\" type=\"browser\">Visit producthunt.com and navigate to the weekly leaderboard page</task>\n<task id=\"2\" type=\"browser\" depends_on=\"1\">Extract the top 10 products (name, tagline, votes, profile URL). Save to products.md</task>\n<task id=\"3\" type=\"document\" depends_on=\"2\">Read products.md and generate an HTML report with product cards</task>\n</tasks>\n\nEach <task> element:\n- \"id\": Sequential number (1, 2, 3...)\n- \"type\": browser, document, code, or multi_modal\n- \"depends_on\" (optional): Comma-separated task IDs this task needs data from\n\n**TASK TO DECOMPOSE:**\n{task}\n{memory_context}\n\nNow decompose into atomic subtasks:";
export declare const COARSE_DECOMPOSE_PROMPT = "Split the task by work type. Keep related operations of the same type together.\n\nTypes:\n- browser: Web browsing, research, online operations\n- document: Writing reports, creating files\n- code: Writing or modifying code, debugging programs, git operations\n\n**CRITICAL Language Policy**:\n- The subtask \"content\" field MUST be in the SAME language as the user's task.\n\nOutput JSON:\n{{\n    \"subtasks\": [\n        {{\"id\": \"1\", \"type\": \"browser\", \"content\": \"...\", \"depends_on\": []}},\n        {{\"id\": \"2\", \"type\": \"document\", \"content\": \"...\", \"depends_on\": [\"1\"]}}\n    ]\n}}\n\nTask: {task}";
export declare const DEFAULT_WORKER_DESCRIPTIONS: Record<string, string>;
export declare const REPLAN_INSTRUCTION = "## Task Splitting\n\nWhen your task involves processing many items (>5), you should split the remaining work.\nBefore splitting, **save all data you have collected so far to a file**.\n\n### How to Split (MUST follow this 2-step process)\n\n**Step 1: Review** \u2014 Call `replan_review_context()` to see:\n- What previous tasks have accomplished\n- What files are available in the workspace\n- What tasks are still pending\n\n**Step 2: Split** \u2014 Call `replan_split_and_handoff(summary, tasks)`:\n- summary: describe what you have done so far\n- tasks: JSON array of follow-up tasks\n\n### Rules for follow-up tasks\n\n1. **Self-Contained**: Each task must include ALL context needed to execute it independently \u2014 specific URLs, search keywords, output file name, data format. The agent executing the task has NO knowledge of your current task or what you have done. Never use references like \"the previous result\", \"continue where I left off\", or \"remaining items\".\n   - Good: \"Visit <url>, extract <specific fields>, save to <filename> as <format>\"\n   - Bad: \"Continue extracting the next batch\"\n\n2. **Clear Deliverables**: Each task must specify what it produces and in what format. Do NOT use vague verbs like \"research\" or \"look into\" without defining the output.\n   - Good: \"Extract name, price, and rating, append to results.json\"\n   - Bad: \"Research more items\"\n\n3. **Atomic**: Each task should be a small, focused unit of work (1-2 tool calls). Browser: one navigation or one data extraction. Document: one file operation.\n\n4. **Parallel by Default**: Tasks that don't depend on each other's output MUST NOT have dependencies. When processing multiple items, create one task per item or small batch \u2014 they can all run in parallel.\n\n5. **Strategic Grouping**: Sequential actions of the same type that MUST happen in order should be grouped into one task.\n\n6. **Preserve the Full Goal**: Your split must cover ALL remaining work.";
export declare const DECOMPOSE_SYSTEM_MESSAGE = "You are a task decomposition expert. Split tasks by work type (browser, document, code).";
//# sourceMappingURL=task-decomposition.d.ts.map