/**
 * PageSnapshot — Captures YAML-like page snapshots using unified_analyzer.js.
 *
 * Ported from page_snapshot.py.
 *
 * Key concepts:
 * - Evaluates unified_analyzer.js in page context
 * - Returns YAML-like accessibility tree with [ref=eN] element references
 * - Diff support for incremental updates
 * - Retry for navigation-destroyed contexts
 */
import type { Page } from "playwright";
export declare class PageSnapshot {
    private page;
    private snapshotData;
    private _lastUrl;
    lastInfo: {
        isDiff: boolean;
        priorities: number[];
    };
    constructor(page: Page);
    capture(options?: {
        forceRefresh?: boolean;
        diffOnly?: boolean;
        viewportLimit?: boolean;
    }): Promise<string>;
    getFullResult(options?: {
        viewportLimit?: boolean;
    }): Promise<Record<string, unknown>>;
    private _getSnapshotDirect;
    private static _formatSnapshot;
    private static _computeDiff;
    private static _detectPriorities;
}
//# sourceMappingURL=page-snapshot.d.ts.map