/**
 * BehaviorRecorder — Records user behavior using ref-based element identification.
 *
 * Ported from behavior_recorder.py.
 *
 * Key concepts:
 * - CDP session per tab for JS → Node binding
 * - Injects behavior_tracker.js via Page.addScriptToEvaluateOnNewDocument
 * - Handles Runtime.bindingCalled for click/type/scroll/navigate events
 * - Network response monitoring for dataload detection
 * - Navigation deduplication (2s window)
 * - Auto-hooks new tab creation
 */
export interface RecordedOperation {
    type: string;
    timestamp: string;
    url?: string;
    ref?: string;
    text?: string;
    role?: string;
    value?: string;
    tab_id?: string;
    direction?: string;
    amount?: number;
    request_url?: string;
    method?: string;
    status?: number;
    [key: string]: unknown;
}
export interface RecordingResult {
    session_id: string;
    operations: RecordedOperation[];
    operations_count: number;
    snapshots: Record<string, SnapshotRecord>;
}
interface SnapshotRecord {
    url: string;
    snapshot_text?: string;
    simple?: Record<string, unknown>;
    captured_at: string;
}
export declare class BehaviorRecorder {
    readonly sessionId: string;
    private _isRecording;
    private _enableSnapshotCapture;
    operations: RecordedOperation[];
    snapshots: Record<string, SnapshotRecord>;
    private _monitoredTabs;
    private _tabPages;
    private _cdpSessions;
    private _fallbackTabCounter;
    private _lastNavUrl;
    private _lastNavTime;
    private _navDedupMs;
    private _browserSession;
    private _operationCallback;
    private _recentDataloadUrls;
    private _dataloadCleanupTimer;
    private _lastScrollTime;
    private _dataloadWindowMs;
    private _responseListeners;
    constructor(enableSnapshotCapture?: boolean);
    setOperationCallback(callback: (op: RecordedOperation) => void): void;
    isRecording(): boolean;
    getOperations(): RecordedOperation[];
    getOperationsCount(): number;
    startRecording(browserSession: any): Promise<void>;
    stopRecording(): Promise<RecordingResult>;
    private _setupAllTabs;
    private _setupForTab;
    private _recordInitialNavigation;
    private _handleBindingEvent;
    private _processOperation;
    private _handleNavigation;
    private _handleResponse;
    private _processResponse;
    private _captureSnapshot;
    private _logOperation;
}
export {};
//# sourceMappingURL=behavior-recorder.d.ts.map